"use strict";

var general = function () {

    var _general = function () {

        $.getScript($("meta[name=_alertJS]").attr('content'), function () {
        });

        $('[data-toggle=popover]').popover();



        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="_csrf"]').attr('content')
            },
        });
        $.fn.select2.defaults.set("allowClear",true);
        $('.modal').on('shown.bs.modal', function() {
            $(document).off('focusin.modal');
        });

        $.fn.modal.Constructor.prototype.enforceFocus = function() {};

        $(document).ready(function () {
            //Toggle fullscreen $("#panel-fullscreen")
            $("body").on("click","#panel-fullscreen",function (e) {
                e.preventDefault();

                var $this = $(this);

                if ($this.children('i').hasClass('fas fa-expand')) {
                    $this.children('i').removeClass('fas fa-expand');
                    $this.children('i').addClass('fas fa-compress');
                } else if ($this.children('i').hasClass('fas fa-compress')) {
                    $this.children('i').removeClass('fas fa-compress');
                    $this.children('i').addClass('fas fa-expand');
                }
                $(this).closest('.card').toggleClass('card-fullscreen');
            });
        });

        $("body").keydown(function (event) {
            if (!$("body").hasClass("modal-open")) {
                if (event.which == 115) { //F4
                    $("#btnSaveAndNew").click();
                    $("#btnUpdateAndReturnDetail").click();
                    return false;
                } else if (event.which == 114) { //F3
                    window.location = $("a[type=reset]").attr("href");
                    return false;
                } else if (event.which == 27) { //ESCs

                    if ($("a[type=reset]").attr("href") ?? $("a[rel=btnBackToList]").attr("href")) {
                    //    window.location = $("a[type=reset]").attr("href") ?? $("a[rel=btnBackToList]").attr("href");
                        return false;
                    }
                }
            }
        });

        $("body").on("click", "#btnPanelStores", function () {
            var data, element;
            element = $(this);
            if (!$("#panelStores").hasClass('show')) return 1;

            $.ajax({
                url: element.data("action")+"?view",
                method: "POST",
                dataType: "JSON",
                data: {},
                success: function (result) {
                    if (result.status) {
                        $("#panelStores").html(result.view);
                    }

                },
                complete: function () {

                },
                error: function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                }

            });


        });

        $("body").on("click", "input[data-action=open]", function (e) {
            if(!e.originalEvent) return false;

            var data, element;
            element = $(this);

            data = {'open' : (element.prop('checked') ? "open" : "close" ), store : element.data('store')}

            $.ajax({
                url: $("meta[name=_setRestaurantStatus]").attr("content"),
                method: "POST",
                dataType: "JSON",
                data: data,
                success: function (result) {
                    if (result.status) {
                       toastr.success(result.message)
                    }else{
                        toastr.error(result.message)
                        element.removeAttr('checked').click();
                    }

                },
                complete: function () {

                },
                error: function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                }

            });


        });

        $("body").on("click", "input[data-action=restaurantCourier]", function (e) {
            if(!e.originalEvent) return false;

            var data, element;
            element = $(this);

            data = {'open' : (element.prop('checked') ? "open" : "close" ), store : element.data('store')}

            $.ajax({
                url: $("meta[name=_setRestaurantCourierStatus]").attr("content"),
                method: "POST",
                dataType: "JSON",
                data: data,
                success: function (result) {
                    if (result.status) {
                       toastr.success(result.message)
                    }else{
                        toastr.error(result.message)
                        element.removeAttr('checked').click();
                    }

                },
                complete: function () {

                },
                error: function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                }

            });


        });


        var successAudio = new Audio($("meta[name=_successOgg]").attr("content"));
        var errorAudio = new Audio($("meta[name=_errorOgg]").attr("content"));
        toastr.subscribe( function (e) {
            if(e.state == 'visible'){
                if(e.map.type == 'success'){
                    successAudio.play();
                }else if(e.map.type == 'error'){
                    errorAudio.play();
                }else{
                    successAudio.play();
                }
            }
        });

    };


    return {
        // public functions
        init: function () {
            _general();
        },
    };

}();

jQuery(document).ready(function () {
    general.init();
});
