"use strict";

var install = function () {

    var _install = function () {



        $('[data-toggle=popover]').popover();

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
            }
        });


        $("body").on("submit", "#installForm", function (e) {
            e.preventDefault();
            var element, data,elementHtml;
            element = $("button[type=submit]");
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);

            data = $(this).serialize();

            $.ajax({
                method: "POST",
                url:  $(this).attr("action"),
                data: data,
                dataType: "JSON",
                success: function (result) {
                    if (result.status === true) {

                        swal.fire("Başarılı", result.message, "success");
                        setTimeout(function () {
                            window.location = result.redirect;
                        }, 1500);
                        $("#btnInstallComplete").html('<i class="fa fa-check"></i>').attr('disabled');


                    } else {
                        element.html(elementHtml).removeAttr('disabled');
                        swal.fire("Hata", result.message, "error");


                    }
                },
                complete: function () {
                   // unblockDiv(element)
                },
                error: function (error) {
                    element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = (error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += (k);
                            });
                        }
                        if (m.length > 0) Swal.fire("Hata", m, "error");
                    }

                }
            });

        });

        $("body").on("click", "#btnCheckLicence", function (e) {

            if($("input[name=licence]").val() == ""){
                toastr.error('Lütfen lisans anahtarını giriniz.');
                $("input[name=licence]").focus();
                return false;
            }

            if($("input[name=company]").val() == ""){
                toastr.error('Lütfen Firma ID giriniz.');
                $("input[name=company]").focus();
                return false;
            }

            var element, data,elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            data = {order: element.parents("tr").attr("id")};

            data = {"licence" : $("input[name=licence]").val(), 'company' : $("input[name=company]").val()};

            $.ajax({
                method: "POST",
                url: element.data("action"),
                data: data,
                dataType: "JSON",
                success: function (result) {
                    if (result.status === true) {

                        swal.fire("Başarılı", result.message, "success");

                        $("#btnCheckLicence").attr('disabled', true).html('<i class="fa fa-check"></i>');
                        $("input[name=licence]").attr("readonly",true);
                        $("input[name=company_name]").val(result.company_name);
                        $("#divDatabase").removeAttr('hidden');

                    } else {
                        element.html(elementHtml).removeAttr('disabled');
                        swal.fire("Hata", result.message, "error");


                    }
                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {
                    element.html(elementHtml).removeAttr('disabled');
                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = (error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += (k);
                            });
                        }

                    }
                    if (m.length > 0) Swal.fire("Hata", m, "error");
                }
            });

        });

        $("body").on("click", "#btnCheckDatabase", function (e) {

            if($("input[name=host]").val() == "" || $("input[name=database]").val() == "" || $("input[name=username]").val() == "" || $("input[name=password]").val() == ""){
                toastr.error('Lütfen sunucu ve veritabanı bilgilerini giriniz.');
                return false;
            }

            var element, data,elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            data = {order: element.parents("tr").attr("id")};

            data = $("#installForm").serialize();

            $.ajax({
                method: "POST",
                url: element.data("action"),
                data: data,
                dataType: "JSON",
                success: function (result) {
                    if (result.status === true) {

                        swal.fire("Başarılı", result.message, "success");

                        $("#btnCheckDatabase").attr('disabled', true).html('<i class="fa fa-check"></i>');
                        $("input[name=host], input[name=database], input[name=username], input[name=password]").attr("readonly",true);
                        $("#btnInstallComplete").removeAttr('hidden');

                    } else {

                        swal.fire("Hata", result.message, "error");


                    }
                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {
                    element.html(elementHtml).removeAttr('disabled');
                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = (error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += (k);
                            });
                        }

                    }
                    if (m.length > 0) Swal.fire("Hata", m, "error");
                }
            });

        });

    };


    return {
        // public functions
        init: function () {
            _install();
        },
    };

}();

jQuery(document).ready(function () {
    install.init();
});
