"use strict";

var login = function () {

    var _login = function () {
        $("#wrapper").css('height', $(window).height());
        $(window).resize(function () {
            $("#wrapper").css('height', $(window).height());
        });

        var password = "";

        $("body").on("submit", "#loginForm", async function (e) {

            e.preventDefault();

            var element, button, data, elementHtml;
            element = $(this);
            button = $("button[type=submit]");
            elementHtml = button.html();
            button.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);

            data = element.serialize();
            $.ajax({
                method: "POST",
                url: element.attr("action"),
                data: data,
                dataType: "JSON",

                success: function (result) {
                    if (result.status) {

                        window.location = result.redirect;


                    } else {
                        password = "";
                        $("input[type=password]").val(password);
                        Swal.fire("Hata", result.message, "error");
                    }
                },
                complete: function () {
                    button.html(elementHtml).attr('disabled', false);
                },
                error: function (error) {
                    button.html(elementHtml).attr('disabled', false);
                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = (error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += (k);
                            });
                        }

                    }
                    if (m.length > 0) Swal.fire("Hata", m, "error");
                }
            });

        });

        $("body").on('click', "button[data-action=btnManuelNumber]", function () {
            var element;
            element = $(this);
            password = password.toString().concat(element.data('value'));
            $("input[type=password]").val(password);
        });

        $("body").on('click', "button[data-action=btnClearBalance]", function () {
            password = "";
            $("input[type=password]").val(password);
        })

        $("body").on('click', "button[data-action=btnBackSpace]", function () {
            if (password.length < 1) return false;
            password = password.substring(0, password.length - 1);
            $("input[type=password]").val(password);
        })

    };

    return {
        // public functions
        init: function () {
            _login();
        },
    };

}();

jQuery(document).ready(function () {
    login.init();
});

