"use strict";

var menu = function () {

    var _menu = function () {

        $.getScript($("meta[name=_alertJS]").attr('content'), function () {
        });


        var menuTable = $("#menuTable").dataTable({

            "PaginationType": "bootstrap",

            ordering: false,
            processing: true,
            serverSide: true,
            paginate: true,
            responsive: false,
            bAutoWidth: false,
            info: false,
            columns: [
                {data: "category"},
                {data: "product"},

                {data: "matching_product",},
                {data: "additional_portion",},
                {data: "unit", className: 'text-center'},
                {data: "portion", className: 'text-center'},
                {data: "status", className: 'text-center'},
                {data: "options", className: 'text-center'},


            ],
            "language": {
                "url": $("meta[name=_trDatatable]").attr("content"),
            },

            ajax: {
                "url": $("#menuTable").data("action"), "type": "POST", "data": function (data) {
                    return $.param(data) + "&store=" + $("input[name=store]").val() + "&show_passive=" + $("#show_passive").prop("checked");
                }, "error": function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    if (m.length > 0) Swal.fire("Hata", m, "error");

                }
            },

            rowId: "rowID",

            "preDrawCallback": function () {

            },

            "fnInitComplete": function () {


            },

            aLengthMenu: [[100, -1], [100, "Tümü"]],
            "pageLength": 100,

            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).attr('id', aData["rowID"]);
            },

            "fnDrawCallback": function () {

                $("select[data-action=qs-menu-select]").select2({
                    placeholder: 'Eşleştirilecek ürün seçiniz', allowClear: true, ajax: {
                        method: "post",
                        url: $("meta[name=_getQSMenuSelect]").attr('content'),
                        cache: true,
                        data: function (query) {
                            return {term: query.term}
                        }
                    }
                });

                $("select[data-action=qs-menu-select]").on("select2:select", function (e) {

                    matchProducts($(e.currentTarget).val(), $(e.currentTarget).parents('tr').attr('id'), e);
                    if ($(e.currentTarget).val().length > 1) {
                        $(e.currentTarget).parents("tr").children("td:eq(3)").children("button").removeAttr("disabled");
                        $(e.currentTarget).parents("tr").children("td:eq(4)").children("select").attr("disabled", true).val(0).change();
                    } else {
                        $(e.currentTarget).parents("tr").children("td:eq(3)").children("button").attr("disabled", true);
                        $(e.currentTarget).parents("tr").children("td:eq(4)").children("select").removeAttr("disabled");
                    }
                });

                $("select[data-action=qs-menu-select]").on("select2:unselect", function (e) {
                    if ($(e.currentTarget).val().length > 1) {
                        $(e.currentTarget).parents("tr").children("td:eq(3)").children("button").removeAttr("disabled");
                        $(e.currentTarget).parents("tr").children("td:eq(4)").children("select").attr("disabled", true).val(0).change();
                    } else {
                        $(e.currentTarget).parents("tr").children("td:eq(3)").children("button").attr("disabled", true);
                        $(e.currentTarget).parents("tr").children("td:eq(4)").children("select").removeAttr("disabled");
                    }
                    removeMatchProduct(e.params.data.id, $(e.currentTarget).parents('tr').attr('id'), e);

                });
            },

            "aoColumnDefs": [{},],
        });
        menuTable = $("#menuTable").DataTable();


        $("body").on("click", "button[data-action=btnOptionSettings]", function (e) {

            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            data = {platformProduct: element.parents("tr").attr("id")};

            $.ajax({
                url: $("meta[name=_getProductOptions]").attr("content"),
                type: "POST",
                data: data,
                dataType: "json",
                success: function (result) {

                    if (result.status) {
                        $("#menuModal").html(result.view).modal('show');
                        initModalSelect()
                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                    unblockDiv($("#menuTable"));
                }
            });

        });


        $("body").on("click", "button[data-action=btnSaveQuantityRelation]", function (e) {

            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            data = {
                platform: $("input[name=platform]").val(),
                store: $("input[name=store]").val(),
                platformProduct: element.parents("tr").attr("id"),
                quantity: element.parent(".input-group").children("input").val()
            };

            $.ajax({
                url: $("meta[name=_setRelationQuantity]").attr("content"),
                type: "POST",
                data: data,
                dataType: "json",
                success: function (result) {

                    if (result.status) {
                        element.html(element).removeAttr('disabled');
                        toastr.success(result.message);
                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                    unblockDiv($("#menuTable"));
                }
            });

        });

        $("body").on("click", "button[data-action=btnSaveAdditionalQuantityRelation]", function (e) {

            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            data = {
                platform: $("input[name=platform]").val(),
                store: $("input[name=store]").val(),
                platformProduct: element.data("product"),
                platformProductMatch: element.parents("tr").attr("id"),
                quantity: element.parent(".input-group").children("input").val()
            };

            $.ajax({
                url: $("meta[name=_setAdditionalQuantity]").attr("content"),
                type: "POST",
                data: data,
                dataType: "json",
                success: function (result) {

                    if (result.status) {
                        element.html(element).removeAttr('disabled');
                        toastr.success(result.message);
                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                    unblockDiv($("#menuTable"));
                }
            });

        });

        $("body").on("click", "button[data-action=btnMultiplePortionSettings]", function (e) {

            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            data = {platformProduct: element.parents("tr").attr("id")};

            $.ajax({
                url: $("meta[name=_getAdditionalPortionView]").attr("content"),
                type: "POST",
                data: data,
                dataType: "json",
                success: function (result) {

                    if (result.status) {
                        $("#menuModal").html(result.view).modal('show');
                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                    unblockDiv($("#menuTable"));
                }
            });

        });

        $("body").on("click", "#btnGetProducts", function (e) {

            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            data = {store: $("input[name=store]").val()};

            $.ajax({
                url: element.data("action"), type: "POST", data: data, dataType: "json", success: function (result) {

                    if (result.status) {
                        menuTable.ajax.reload(null, false);
                        toastr.success(result.message);
                    } else {
                        toastr.error(result.message);
                    }

                }, complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                }, error: function (error) {
                    element.html(elementHtml).removeAttr('disabled');
                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                    unblockDiv($("#menuTable"));
                }
            });

        });

        $("body").on('change', "select[id^=portion]", function () {
            $.ajax({
                method: "POST", url: $("meta[name=_matchPortion]").attr("content"),
                data: {
                    platform: $("input[name=platform]").val(),
                    store: $("input[name=store]").val(),
                    platformProduct: $(this).parents('tr').attr('id'),
                    portion: $(this).val(),

                }, dataType: "JSON", success: function (result) {
                    if (result.status) {
                        toastr.success(result.message);


                    } else {

                        toastr.error(result.message);
                    }
                }, complete: function () {

                }, error: function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    if (m.length > 0) Swal.fire("Hata", m, "error");
                }
            });
        });

        $("body").on('change', "select[id^=optionPortion_]", function () {
            $.ajax({
                method: "POST", url: $("meta[name=_matchOptionPortion]").attr("content"),
                data: {
                    platform: $("input[name=platform]").val(),
                    store: $("input[name=store]").val(),
                    platformOption: $(this).parents('tr').attr('id'),
                    portion: $(this).val(),

                }, dataType: "JSON", success: function (result) {
                    if (result.status) {
                        toastr.success(result.message);


                    } else {

                        toastr.error(result.message);
                    }
                }, complete: function () {

                }, error: function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    if (m.length > 0) Swal.fire("Hata", m, "error");
                }
            });
        });

        $("body").on('change', "select[id^=productAdditionalPortion_]", function () {
            $.ajax({
                method: "POST", url: $("meta[name=_setAdditionalPortion]").attr("content"),
                data: {
                    platform: $("input[name=platform]").val(),
                    store: $("input[name=store]").val(),
                    platformProductMatch: $(this).parents('tr').attr('id'),
                    platformProduct: $(this).data('product'),
                    portion: $(this).val(),

                }, dataType: "JSON", success: function (result) {
                    if (result.status) {
                        toastr.success(result.message);
                    } else {
                        toastr.error(result.message);
                    }
                }, complete: function () {

                }, error: function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    if (m.length > 0) Swal.fire("Hata", m, "error");
                }
            });
        });

        $("#show_passive").change(function () {
            menuTable.ajax.reload(null, false);
        });

        function matchProducts(qsProduct, platformProduct, e) {

            $.ajax({
                method: "POST", url: $("meta[name=_matchProduct]").attr("content"),
                data: {
                    qsProduct: qsProduct,
                    platformProduct: platformProduct,
                    platform: $("input[name=platform]").val(),
                    store: $("input[name=store]").val(),
                    portion: $("#portion_" + platformProduct + " > option:selected").val()
                }, dataType: "JSON", success: function (result) {
                    if (result.status) {
                        toastr.success(result.message);

                        menuTable.cell("#" + platformProduct, 6).data(result.status_view);
                        //   console.log(menuTable.cell("#" + platformProduct,3).cell(':eq(3)').data())
                    } else {
                        $(e.currentTarget).val(null).trigger('change')
                        toastr.error(result.message);
                    }
                }, complete: function () {

                }, error: function (error) {
                    $(e.currentTarget).val(null).trigger('change')
                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    if (m.length > 0) Swal.fire("Hata", m, "error");
                }
            });

        }

        $("body").on("click", "button[data-action=btnSaveAdditionalOptionQuantityRelation]", function () {
            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);

            $.ajax({
                method: "POST", url: $("meta[name=_matchOptionQuantity]").attr("content"), data: {
                    platformOption: $(this).parents('tr').attr('id'),
                    quantity: $(this).parents(".input-group").children("input").val(),
                    platform: $("input[name=platform]").val(),
                    store: $("input[name=store]").val(),

                }, dataType: "JSON", success: function (result) {
                    if (result.status) {
                        toastr.success(result.message);


                    } else {
                        $(e.currentTarget).val(null).trigger('change')
                        toastr.error(result.message);
                    }
                }, complete: function () {

                    element.html(elementHtml).removeAttr('disabled');


                }, error: function (error) {
                    element.html(elementHtml).removeAttr('disabled');


                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    if (m.length > 0) Swal.fire("Hata", m, "error");
                }
            });
        })

        function matchOption(qsOption, platformOption, e) {

            $.ajax({
                method: "POST", url: $("meta[name=_matchOption]").attr("content"), data: {
                    qsOption: qsOption,
                    platformOption: platformOption,
                    platform: $("input[name=platform]").val(),
                    store: $("input[name=store]").val(),
                    portion: $("#optionPortion_" + platformOption + " > option:selected").val()
                }, dataType: "JSON", success: function (result) {
                    if (result.status) {
                        toastr.success(result.message);
                        $("#optionsTable tbody tr#" + platformOption + " td:eq(5)").html(result.status_view);

                    } else {
                        $(e.currentTarget).val(null).trigger('change')
                        toastr.error(result.message);
                    }
                }, complete: function () {

                }, error: function (error) {
                    $(e.currentTarget).val(null).trigger('change')
                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    if (m.length > 0) Swal.fire("Hata", m, "error");
                }
            });

        }

        function removeMatchProduct(qsProduct, platformProduct, e) {
            //   console.log(qsProduct, platformProduct)

            $.ajax({
                method: "POST", url: $("meta[name=_removeMatchProduct]").attr("content"), data: {
                    qsProduct: qsProduct,
                    platformProduct: platformProduct,
                    platform: $("input[name=platform]").val(),
                    store: $("input[name=store]").val()
                }, dataType: "JSON", success: function (result) {
                    if (result.status) {
                        toastr.success(result.message);
                        menuTable.cell("#" + platformProduct, 5).data(result.status_view);
                    } else {
                        $(e.currentTarget).val(qsProduct).trigger('change');
                        toastr.error(result.message);

                    }
                }, complete: function () {

                }, error: function (error) {
                    $(e.currentTarget).val(qsProduct).trigger('change');
                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    if (m.length > 0) Swal.fire("Hata", m, "error");
                }
            });

        }

        function removeMatchOption(qsOption, platformOption, e) {


            $.ajax({
                method: "POST", url: $("meta[name=_removeMatchOption]").attr("content"), data: {
                    qsOption: qsOption,
                    platformOption: platformOption,
                    platform: $("input[name=platform]").val(),
                    store: $("input[name=store]").val()
                }, dataType: "JSON", success: function (result) {
                    if (result.status) {
                        toastr.success(result.message);
                        $("#optionsTable tbody tr#" + platformOption + " td:eq(5)").html(result.status_view);
                    } else {
                        $(e.currentTarget).val(platformOption).trigger('change');
                        toastr.error(result.message);

                    }
                }, complete: function () {

                }, error: function (error) {
                    $(e.currentTarget).val(platformOption).trigger('change');
                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    if (m.length > 0) Swal.fire("Hata", m, "error");
                }
            });

        }

        function initModalSelect() {


            $("select[data-action=qs-option-select]").select2({
                allowClear: true, dropdownParent: $('#menuModal'), placeholder: "Opsiyon Seçimi", ajax: {
                    method: "post",
                    url: $("meta[name=_getQSOptionSelect]").attr('content'),
                    cache: true,
                    data: function (query) {
                        return {term: query.term}
                    }
                }
            });

            $("select[data-action=qs-option-select]").on("select2:select", function (e) {

                matchOption(e.params.data.id, $(e.currentTarget).parents('tr').attr('id'), e);

            });

            $("select[data-action=qs-option-select]").on("select2:clearing", function (e) {
                removeMatchOption(e.params.args.data[0].id, $(e.currentTarget).parents('tr').attr('id'), e);

            });
        }

    };


    return {
        // public functions
        init: function () {
            _menu();
        },
    };

}();

jQuery(document).ready(function () {
    menu.init();
});

