"use strict";

var menu = function () {

    var _menu = function () {

        $.getScript($("meta[name=_alertJS]").attr('content'), function () {
        });


        var menuTable = $("#menuTable").dataTable({

            "PaginationType": "bootstrap",

            ordering: false,
            processing: true,
            serverSide: true,
            paginate: true,
            responsive: false,
            bAutoWidth: false,
            info: false,
            columns: [
                {data: "category"},
                {data: "product"},
                {data: "status", className: 'text-center'},
                {data: "options", className: 'text-center'},
                {data: "action", className: 'text-center'},


            ],
            "language": {
                "url": $("meta[name=_trDatatable]").attr("content"),
            },

            ajax: {
                "url": $("#menuTable").data("action"), "type": "POST", "data": function (data) {
                    return $.param(data) + "&store=" + $("input[name=store]").val();
                }, "error": function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    if (m.length > 0) Swal.fire("Hata", m, "error");

                }
            },

            rowId: "rowID",

            "preDrawCallback": function () {

            },

            "fnInitComplete": function () {


            },

            aLengthMenu: [[100, -1], [100, "Tümü"]],
            "pageLength": 100,

            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).attr('id', aData["rowID"]);
            },

            "fnDrawCallback": function () {


            },

            "aoColumnDefs": [{},],
        });
        menuTable = $("#menuTable").DataTable();
        var globalOptionButton;

        $("body").on("click", "button[data-action=btnProductStatus]", function (e) {

            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            data = {
                store: $("input[name=store]").val(),
                product: element.parents("tr").attr("id"),
                type: element.data('status')
            };

            $.ajax({
                url: $("meta[name=_setProductStatus]").attr("content"),
                type: "POST",
                data: data,
                dataType: "json",
                success: function (result) {

                    if (result.status) {
                        toastr.success(result.message);
                        menuTable.ajax.reload(null, false);
                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                    unblockDiv($("#menuTable"));
                }
            });

        });

        $("body").on("click", "button[data-action=btnProductOptionStatus]", function (e) {

            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            data = {
                store: $("input[name=store]").val(),
                option: element.parents("tr").attr("id"),
                type: element.data('status')
            };

            $.ajax({
                url: $("meta[name=_setProductOptionStatus]").attr("content"),
                type: "POST",
                data: data,
                dataType: "json",
                success: function (result) {

                    if (result.status) {
                        toastr.success(result.message);
globalOptionButton.click();
                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                    unblockDiv($("#menuTable"));
                }
            });

        });

        $("body").on("click", "button[data-action=btnOptionSettings]", function (e) {

            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            data = {platformProduct: element.parents("tr").attr("id")};
            globalOptionButton = element;
            $.ajax({
                url: $("meta[name=_getProductOptions]").attr("content"),
                type: "POST",
                data: data,
                dataType: "json",
                success: function (result) {

                    if (result.status) {
                        $("#menuModal").html(result.view).modal('show');

                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                    unblockDiv($("#menuTable"));
                }
            });

        });

        $("body").on("click", "#btnGetProducts", function (e) {

            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            data = {store: $("input[name=store]").val()};

            $.ajax({
                url: element.data("action"), type: "POST", data: data, dataType: "json", success: function (result) {

                    if (result.status) {
                        menuTable.ajax.reload(null, false);
                        toastr.success(result.message);
                    } else {
                        toastr.error(result.message);
                    }

                }, complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                }, error: function (error) {
                    element.html(elementHtml).removeAttr('disabled');
                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                    unblockDiv($("#menuTable"));
                }
            });

        });
    };


    return {
        // public functions
        init: function () {
            _menu();
        },
    };

}();

jQuery(document).ready(function () {
    menu.init();
});

