"use strict";

var menus = function () {

    var _menu = function () {

        $.getScript($("meta[name=_alertJS]").attr('content'), function () {
        });


        var menusTable = $("#menusTable").dataTable({

            "PaginationType": "bootstrap",

            ordering: false,
            processing: true,
            serverSide: true,
            paginate: false,
            responsive:true,
            info: false,
            columns: [
                {data: "platform"},
                {data: "store"},

                {data: "total_product", className: 'text-center'},


                {data: "actions"},

            ],
            "language": {
                "url": $("meta[name=_trDatatable]").attr("content"),
            },

            ajax: {
                "url": $("#menusTable").data("action"),
                "type": "POST",
                "error": function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    if (m.length > 0) Swal.fire("Hata", m, "error");

                }
            },

            rowId: "rowID",

            "preDrawCallback": function () {

            },

            "fnInitComplete": function () {

            },

            aLengthMenu: [[100, -1], [100, "Tümü"]],
            "pageLength": 100,

            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).attr('id', aData["rowID"]);
            },

            "fnDrawCallback": function () {


            },

            "aoColumnDefs": [
                {
                    'bSortable': false,
                    'aTargets': [0]
                },


            ],





        });


        $("body").on("click", "button[data-action=delete]", function (e) {

            var element, data;
            element = $(this);

            swal.fire({
                title: "Emin misiniz ?",
                text: "Seçilen kayıt silinecektir. Bu işlemin geri dönüşü yoktur.",
                icon: "warning",
                showCancelButton: true,
                cancelButtonText: "Hayır, vazgeç",
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Evet, sil",
                reverseButtons: false
            }).then((result) => {
                if (result.value) {

                    data = {data: [element.parents("tr").attr("id")]};
                    blockDiv($("#menusTable"));

                    $.ajax({
                        url: $("meta[name=_deletemenus]").attr("content"),
                        type: "POST",
                        data: data,
                        dataType: "json",
                        success: function (result) {

                            if (result.status === true) {
                                menusTable = $("#menusTable").DataTable();
                                toastr.options = {
                                    "showDuration": "1250",
                                    "hideDuration": "1000",
                                    "timeOut": "5000",
                                    "extendedTimeOut": "1000",
                                    "progressBar": true,
                                };


                                $("tr.selected").removeClass("selected");


                                $.each(result.detail.error, function (i, v) {
                                    toastr.error(v);
                                });
                                $.each(result.detail.success.name, function (i, v) {
                                    toastr.success(v);
                                    menusTable.rows("#" + result.detail.success.id[i]).remove().draw(false);
                                });
                                toastr.info(result.message);


                            } else {
                                Swal.fire("Hata !", result.message, "error");
                            }
                            unblockDiv($("#menusTable"));
                        },
                        error: function (error) {

                            if (error.responseJSON) {
                                var m = "";
                                if (error.responseJSON.message) {
                                    m = ErrorWB(error.responseJSON.message);
                                }
                                if (error.responseJSON.errors) {

                                    $.each(error.responseJSON.errors, function (i, k) {
                                        m += ErrorWB(k);
                                    });
                                }

                            }
                            Swal.fire("Hata !", m, "error");
                            unblockDiv($("#menusTable"));
                        }
                    });
                }
            });

        });

        $("body").on("click", "#btnDeleteSelected", function (e) {

            var data, selectedItem;
            if ($("#menusTable tr.selected").length) {
                swal.fire({
                    title: "Emin misiniz ?",
                    text: "Seçilen kayıt(lar) silinecektir. Bu işlemin geri dönüşü yoktur.",
                    icon: "warning",
                    showCancelButton: true,
                    cancelButtonText: "Hayır, vazgeç",
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "Evet, sil",
                    reverseButtons: false
                }).then((result) => {

                    if (result.value) {
                        selectedItem = [];
                        $("#menusTable tr.selected").each(function (i, v) {
                            selectedItem.push($(v).attr("id"));
                        });

                        data = {data: selectedItem};

                        blockDiv($("#menusTable"));
                        $.ajax({
                            url: $("meta[name=_deletemenus]").attr("content"),
                            type: "POST",
                            data: data,
                            dataType: "json",
                            success: function (result) {

                                if (result.status === true) {
                                    menusTable = $("#menusTable").DataTable();
                                    toastr.options = {
                                        "showDuration": "1250",
                                        "hideDuration": "1000",
                                        "timeOut": "5000",
                                        "extendedTimeOut": "1000",
                                        "progressBar": true,
                                    };


                                    $("tr.selected").removeClass("selected");


                                    $.each(result.detail.error, function (i, v) {
                                        toastr.error(v);
                                    });
                                    $.each(result.detail.success.name, function (i, v) {
                                        toastr.success(v);
                                        menusTable.rows("#" + result.detail.success.id[i]).remove().draw(false);
                                    });
                                    toastr.info(result.message);


                                } else {
                                    Swal.fire("Hata !", result.message, "error");
                                }
                                unblockDiv($("#menusTable"));
                            },
                            error: function (error) {

                                if (error.responseJSON) {
                                    var m = "";
                                    if (error.responseJSON.message) {
                                        m = ErrorWB(error.responseJSON.message);
                                    }
                                    if (error.responseJSON.errors) {

                                        $.each(error.responseJSON.errors, function (i, k) {
                                            m += ErrorWB(k);
                                        });
                                    }

                                }
                                Swal.fire("Hata !", m, "error");
                                unblockDiv($("#menusTable"));
                            }
                        });
                    }
                });
            }


        });

        $('#menusTable tbody').on('dblclick', 'tr', function () {
            menusTable = $("#menusTable").DataTable();
            var data = menusTable.row(this).data();
            window.location = data.dataURL;
        });

        $('#transactionsModal, #clientTransferModal').on('hidden.bs.modal', function () {
            menusTable = $("#menusTable").DataTable();
            subTotalTable = $("#subTotalTable").DataTable();
            menusTable.ajax.reload();
            subTotalTable.ajax.reload();
        })


    };


    return {
        // public functions
        init: function () {
            _menu();
        },
    };

}();

jQuery(document).ready(function () {
    menus.init();
});

