"use strict";

var orders = function () {

    var _menu = function () {

        $.getScript($("meta[name=_alertJS]").attr('content'), function () {
        });

        var exportPageTitle = "Tüm Siparişler";
        var exportColumns = ':visible';
        var ordersTable = $("#ordersTable").dataTable({

            "PaginationType": "bootstrap",

            ordering: false,
            processing: false,
            serverSide: true,
            paginate: true,
            responsive: true,
            info: true,
            scrollY: '40vh',
            scrollX: true,
            columns: [
                {data: "platform"},
                {data: "store"},
                {data: "order_date"},
                {data: "order_time"},
                {data: "customer"},
                {data: "total_amount"},
                {data: "confirmation_time"},
                {data: "preparation_time"},
                {data: "total_time"},
                {data: "status"},
                {data: "payment_method"},
                {data: "courier"},
                {data: "actions"},
            ],
            "language": {
                "url": $("meta[name=_trDatatable]").attr("content"),
            },

            ajax: {
                "url": $("#ordersTable").data("action"),
                "type": "POST",
                "data": function (d) {
                    return $("#searchForm").serialize() + '&' + $.param(d);
                },
                "error": function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    if (m.length > 0) Swal.fire("Hata", m, "error");

                }
            },

            rowId: "rowID",

            "preDrawCallback": function () {

            },

            "fnInitComplete": function () {

            },

            aLengthMenu: [[100, -1], [100, "Tümü"]],
            "pageLength": 100,

            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).attr('id', aData["rowID"]);
            },

            "fnDrawCallback": function () {



            },

            "aoColumnDefs": [
                {
                    'bSortable': false,
                    'aTargets': [0]
                },


            ],


        });
        ordersTable = $("#ordersTable").DataTable();



        $("body").on('click', 'button[data-action=btnViewOrder]', function () {
            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            data = {order: element.parents("tr").attr("id")};

            $.ajax({
                url: $("meta[name=_getOrder]").attr("content").replace('id', data.order),
                type: "POST",
                data: {},
                dataType: "json",
                success: function (result) {

                    if (result.status) {
                       $("#orderbox").html(result.view).addClass('active');

                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {
                    element.html(elementHtml).removeAttr('disabled');
                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");

                }
            });
        });


        $("body").on('click', 'button[data-action=btnPrintOrder]', function () {
          //  $("#orderbox").printElement({printMode: 'iframe'});
            printJS({ printable: 'DZ_W_Order_Body3', type: 'html', css : ['/assets/css/print-style.css"'] });
        });


        $('body').on('click', "#orderbox-close", function () {
            $('#orderbox').removeClass('active');
        });


        $("body").on("submit", "#searchForm", function (event) {

            event.preventDefault();
            //blockDiv($("#invoicesTable"));


            ordersTable.ajax.reload(null, false);
            ordersTable.page(1);


        });

        $("#kt_datepicker").datepicker({
            format: "dd.mm.yyyy",
            language: "tr",
            todayHighlight: !0,
            autoclose: true,
            templates: {leftArrow: '<i class="la la-angle-left"></i>', rightArrow: '<i class="la la-angle-right"></i>'}
        });

        $("body").on("click", "#btnDatePrev", function () {

            if (!$("input[name=start_date]").val()) {
                var d = new Date();
                d.setDate(d.getDate());
                $("input[name=start_date]").val(d.toLocaleDateString());
            }

            if ($("input[name=start_date]").val()) {
                var date = $("input[name=start_date]").val().split(".");
                var d = new Date(date[2] + "-" + date[1] + "-" + date[0]);
                d.setDate(d.getDate() - 1);
                $("input[name=start_date]").val(d.toLocaleDateString());
                $("input[name=end_date]").val(d.toLocaleDateString());


            }

            $("#searchForm").submit();

        });

        $("body").on("click", "#btnDateNext", function () {
            if (!$("input[name=end_date]").val()) {
                var d = new Date();
                d.setDate(d.getDate());
                $("input[name=end_date]").val(d.toLocaleDateString());
            }

            if ($("input[name=end_date]").val()) {
                var date = $("input[name=end_date]").val().split(".");
                var d = new Date(date[2] + "-" + date[1] + "-" + date[0]);
                d.setDate(d.getDate() + 1);
                $("input[name=end_date]").val(d.toLocaleDateString());
                $("input[name=start_date]").val(d.toLocaleDateString());
            }

            $("#searchForm").submit();


        });



        $("body").on("click", "#kt_reset", function () {
            $("#searchForm")[0].reset();
            $("input[name=start_date], input[name=end_date]").val(null);
            $('#ordersTable').DataTable().search("");
            $('#ordersTable').DataTable().page(1);



        })

        moment.localeData('tr');

        $("body").on("click", "#btnDateToday", function () {

            $("input[name=start_date], input[name=end_date]").val(moment().format("DD.MM.YYYY"));

            $("#searchForm").submit();

        });

        $("body").on("click", "#btnDateYesterday", function () {

            $("input[name=start_date], input[name=end_date]").val(moment().subtract(1, 'days').format("DD.MM.YYYY"));

            $("#searchForm").submit();

        });

        $("body").on("click", "#btnDateThisWeek", function () {

            $("input[name=start_date]").val(moment().locale("tr").startOf("week").format("DD.MM.YYYY"));
            $("input[name=end_date]").val(moment().format("DD.MM.YYYY"));

            $("#searchForm").submit();

        });

        $("body").on("click", "#btnDateThisMonth", function () {

            $("input[name=start_date]").val(moment().startOf('month').format("DD.MM.YYYY"));
            $("input[name=end_date]").val(moment().format("DD.MM.YYYY"));

            $("#searchForm").submit();

        });

        $("body").on("click", "#btnDateThisYear", function () {

            $("input[name=start_date]").val(moment().startOf('year').format("DD.MM.YYYY"));
            $("input[name=end_date]").val(moment().format("DD.MM.YYYY"));

            $("#searchForm").submit();

        });


    };


    return {
        // public functions
        init: function () {
            _menu();
        },
    };

}();

jQuery(document).ready(function () {
    orders.init();
});

