"use strict";

var orders = function () {

    var _menu = function () {

        $.getScript($("meta[name=_alertJS]").attr('content'), function () {
        });

        var exportPageTitle = "Aktif Siparişler";
        var exportColumns = ':visible';
        var pendingOrdersTable = $("#pendingOrdersTable").dataTable({

            "PaginationType": "bootstrap",

            ordering: false,
            processing: false,
            serverSide: true,
            paginate: true,
            responsive: true,
            info: true,
            scrollY: '40vh',
            scrollX: true,
            columns: [
                {data: "platform"},
                {data: "store"},
                {data: "order_date"},
                {data: "order_time"},
                {data: "customer"},
                {data: "total_amount"},
                {data: "confirmation_time"},
                {data: "preparation_time"},
                {data: "total_time"},
                {data: "status"},
                {data: "payment_method"},
                {data: "courier"},
                {data: "actions"},
            ],
            "language": {
                "url": $("meta[name=_trDatatable]").attr('content'),
            },

            ajax: {
                "url": $("#pendingOrdersTable").data("action"),
                "type": "POST",
                "data": function () {
                    return {action: 'pending', 'date' : "current_date"}
                },
                "error": function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    if (m.length > 0) Swal.fire("Hata", m, "error");

                }
            },

            rowId: "rowID",

            "preDrawCallback": function () {

            },

            "fnInitComplete": function () {

            },

            aLengthMenu: [[100, -1], [100, "Tümü"]],
            "pageLength": 100,

            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).attr('id', aData["rowID"]);
            },

            "fnDrawCallback": function () {

                $("span[data-action=confirmationTimer]").each(function (i, v) {
                    setInterval(function () {
                        if ($(v).data('timer-end') === false) {
                            countUpTimer($(v).data('timer'), v);
                        }
                    }, 1000);
                });

                $("span[data-action=preparationTimer]").each(function (i, v) {

                    setInterval(function () {

                        if ($(v).data('timer-end') == false) {

                            countUpTimer($(v).data('timer'), v);
                        }
                    }, 1000);
                });

                $("span[data-action=totalTimer]").each(function (i, v) {

                    setInterval(function () {

                        if ($(v).data('timer-end') == false) {

                            countUpTimer($(v).data('timer'), v);
                        }
                    }, 1000);
                });
            },

            "aoColumnDefs": [
                {
                    'bSortable': false,
                    'aTargets': [0]
                },


            ],


        });
        pendingOrdersTable = $("#pendingOrdersTable").DataTable();

        exportPageTitle = "Tamamlanmış Siparişler";
        exportColumns = ':visible';
        var completeOrdersTable = $("#completeOrdersTable").dataTable({

            "PaginationType": "bootstrap",

            ordering: false,
            processing: true,
            serverSide: true,
            paginate: true,
            responsive: true,
            info: true,
            scrollY: '40vh',
            scrollX: true,
            columns: [
                {data: "platform"},
                {data: "store"},
                {data: "order_date"},
                {data: "order_time"},
                {data: "customer"},
                {data: "total_amount"},
                {data: "confirmation_time"},
                {data: "preparation_time"},
                {data: "total_time"},
                {data: "status"},
                {data: "payment_method"},
                {data: "courier"},
                {data: "actions"},
            ],
            "language": {
                "url": $("meta[name=_trDatatable]").attr("content"),
            },

            ajax: {
                "url": $("#completeOrdersTable").data("action"),
                "type": "POST",
                "data": function () {
                    return {action: 'complete','date' :  $("#completeOrdersTable").data("type")}
                },
                "error": function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    if (m.length > 0) Swal.fire("Hata", m, "error");

                }
            },

            rowId: "rowID",

            "preDrawCallback": function () {

            },

            "fnInitComplete": function () {

            },

            aLengthMenu: [[100, -1], [100, "Tümü"]],
            "pageLength": 100,

            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).attr('id', aData["rowID"]);
            },

            "fnDrawCallback": function () {

            },

            "aoColumnDefs": [
                {
                    'bSortable': false,
                    'aTargets': [0]
                },


            ],


        });
        completeOrdersTable = $("#completeOrdersTable").DataTable();

        setInterval(function (){
            pendingOrdersTable.ajax.reload(null,false);
        },2500);

        $("body").on('click', 'button[data-action=btnOrderConfirm]', function () {
            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            data = {order: element.parents("tr").attr("id")};

            $.ajax({
                url: $("meta[name=_confirmOrder]").attr("content").replace('id', data.order),
                type: "POST",
                data: {},
                dataType: "json",
                success: function (result) {

                    if (result.status) {
                        pendingOrdersTable.ajax.reload(null, false);
                        toastr.success(result.message);
                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {
                    element.html(elementHtml).removeAttr('disabled');
                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");

                }
            });
        });

        $("body").on('click', 'button[data-action=btnOrderDeliver]', async function () {
            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            data = {order: element.parents("tr").attr("id")};

            $.ajax({
                url: $("meta[name=_getCouriers]").attr("content").replace('id', data.order),
                type: "POST",
                data: {},
                dataType: "json",
                success: async function (result) {

                    if (result.status) {
                        var couriers = result.couriers;

                        const {value: courier} = await Swal.fire({
                            title: 'Kurye Seçmi Yapınız',
                            input: 'select',
                            inputOptions: couriers,
                            inputPlaceholder: 'Kurye',
                            showCancelButton: true,
                            inputValidator: (value) => {
                                return new Promise((resolve) => {
                                    if (value) {
                                        resolve()
                                    } else {
                                        resolve('Kurye seçimi yapmanız gerekmektedir.')
                                    }
                                })
                            }
                        })

                        if (courier) {
                            $.ajax({
                                url: $("meta[name=_deliverOrder]").attr("content").replace('id', data.order),
                                type: "POST",
                                data: {courier : courier},
                                dataType: "json",
                                success: function (result) {

                                    if (result.status) {
                                        pendingOrdersTable.ajax.reload(null, false);
                                        toastr.success(result.message);
                                    } else {
                                        toastr.error(result.message);
                                    }

                                },
                                complete: function () {
                                    element.html(elementHtml).removeAttr('disabled');
                                },
                                error: function (error) {
                                    element.html(elementHtml).removeAttr('disabled');
                                    if (error.responseJSON) {
                                        var m = "";
                                        if (error.responseJSON.message) {
                                            m = ErrorWB(error.responseJSON.message);
                                        }
                                        if (error.responseJSON.errors) {

                                            $.each(error.responseJSON.errors, function (i, k) {
                                                m += ErrorWB(k);
                                            });
                                        }

                                    }
                                    Swal.fire("Hata !", m, "error");

                                }
                            });
                        }
                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {
                    element.html(elementHtml).removeAttr('disabled');
                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");

                }
            });




        });

        $("body").on('click', 'button[data-action=btnOrderHandover]', function () {
            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            data = {order: element.parents("tr").attr("id")};

            $.ajax({
                url: $("meta[name=_handoverOrder]").attr("content").replace('id', data.order),
                type: "POST",
                data: {},
                dataType: "json",
                success: function (result) {

                    if (result.status) {
                        pendingOrdersTable.ajax.reload(null, false);
                        completeOrdersTable.ajax.reload(null, false);
                        toastr.success(result.message);
                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {
                    element.html(elementHtml).removeAttr('disabled');
                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                }
            });
        });

        $("body").on('click', 'button[data-action=btnViewOrder]', function () {
            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            data = {order: element.parents("tr").attr("id")};

            $.ajax({
                url: $("meta[name=_getOrder]").attr("content").replace('id', data.order),
                type: "POST",
                data: {},
                dataType: "json",
                success: function (result) {

                    if (result.status) {
                       $("#orderbox").html(result.view).addClass('active');

                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {
                    element.html(elementHtml).removeAttr('disabled');
                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");

                }
            });
        });

        $("body").on('click', 'button[data-action=btnOrderReject]', function () {
            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            data = {order: element.parents("tr").attr("id")};

            $.ajax({
                url: $("meta[name=_rejectOrderStatuses]").attr("content").replace('id', data.order),
                type: "POST",
                data: {},
                dataType: "json",
                success: function (result) {

                    if (result.status) {
                        viewCancelOptions(result.data,element,elementHtml);

                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                    unblockDiv($("#menuTable"));
                }
            });
        });

        function countUpTimer(totalSeconds, element) {
            ++totalSeconds;
            var day = Math.floor(totalSeconds / 86400);
            var hour = Math.floor(totalSeconds / 3600);
            var minute = Math.floor((totalSeconds - hour * 3600) / 60);
            var seconds = totalSeconds - (hour * 3600 + minute * 60);
            var timerHtml = "";
            if (day > 0) timerHtml += day + "g ";
            if (hour > 0) timerHtml += hour + "s ";
            if (minute > 0) timerHtml += minute + "dk ";
            if (seconds > 0) timerHtml += seconds + "sn ";
            var percentage = $(element).data('percentage') + $(element).data('percentage-amount');
            $(element).parents(".progress-bar").css('width', percentage > 100 ? "100%" : percentage+"%");
            $(element).data('timer', totalSeconds)
            $(element).data('percentage', percentage)
            $(element).html(timerHtml);
            if (percentage > 100) {
                $(element).parents(".progress-bar").removeClass('bg-success').addClass('bg-danger');
            }
        }


        $("body").on('click', 'button[data-action=btnPrintOrder]', function () {
          //  $("#orderbox").printElement({printMode: 'iframe'});
            printJS({ printable: 'DZ_W_Order_Body3', type: 'html', css : ['/assets/css/print-style.css"'] });
        });


        $('body').on('click', "#orderbox-close", function () {
            $('#orderbox').removeClass('active');
        });


        async function viewCancelOptions(data,element, elementHtml) {
            const inputOptions = new Promise((resolve) => {
                resolve(data)
            })

            const {value: option} = await Swal.fire({
                title: 'Sipariş İptal gerekçesini seçiniz',
                input: 'radio',
                inputOptions: inputOptions,
                customClass:{
                  'input' : 'd-inline',
                },
                inputValidator: (value) => {
                    if (!value) {
                        return 'Siparişi iptal etmek için seçim yapmanız gerekir.'
                    }
                }
            })


            if(option){
                elementHtml = element.html();
                element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
                data = {order: element.parents("tr").attr("id"), reason : option};
                $.ajax({
                    url: $("meta[name=_rejectOrder]").attr("content").replace('id', data.order),
                    type: "POST",
                    data: data,
                    dataType: "json",
                    success: function (result) {

                        if (result.status) {
                            toastr.success(result.message);
                            pendingOrdersTable.ajax.reload(null, false);
                            completeOrdersTable.ajax.reload(null, false);

                        } else {
                            toastr.error(result.message);
                        }

                    },
                    complete: function () {
                        element.html(elementHtml).removeAttr('disabled');
                    },
                    error: function (error) {

                        if (error.responseJSON) {
                            var m = "";
                            if (error.responseJSON.message) {
                                m = ErrorWB(error.responseJSON.message);
                            }
                            if (error.responseJSON.errors) {

                                $.each(error.responseJSON.errors, function (i, k) {
                                    m += ErrorWB(k);
                                });
                            }

                        }
                        Swal.fire("Hata !", m, "error");

                    }
                });
            }
        }



    };


    return {
        // public functions
        init: function () {
            _menu();
        },
    };

}();

jQuery(document).ready(function () {
    orders.init();
});

