"use strict";

var platforms = function () {

    var _platform = function () {

        $.getScript('/application/system/define/alerts.js', function () {
        });

        $("body").on("click", "button[data-action=btnSetPlatformStatus]", function (e) {

            var element, data, elementHtml;
            element = $(this);
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            swal.fire({
                title: "Emin misiniz ?",
                text: element.data("name") + " - " + element.data("store") + " mağazası " + (element.data('status') ? "aktif" : "pasif") + " edilecektir.",
                icon: "info",
                showCancelButton: true,
                cancelButtonText: "Hayır, vazgeç",
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Evet, " + (element.data('status') ? "Aktifleştir" : "Pasifleştir"),
                reverseButtons: false
            }).then((result) => {
                if (result.value) {

                    data = {store: element.data("pf"), status: element.data('status')};


                    $.ajax({
                        url: $("meta[name=_setPlatformStatus]").attr('content'),
                        type: "POST",
                        data: data,
                        dataType: "json",
                        success: function (result) {

                            if (result.status === true) {
                                toastr.success(result.message)
                                getStores()
                            } else {
                                Swal.fire("Hata !", result.message, "error");
                            }
                            element.html(elementHtml).removeAttr('disabled');
                        },
                        error: function (error) {
                            element.html(elementHtml).removeAttr('disabled');
                            if (error.responseJSON) {
                                var m = "";
                                if (error.responseJSON.message) {
                                    m = ErrorWB(error.responseJSON.message);
                                }
                                if (error.responseJSON.errors) {

                                    $.each(error.responseJSON.errors, function (i, k) {
                                        m += ErrorWB(k);
                                    });
                                }

                            }
                            Swal.fire("Hata !", m, "error");
                            unblockDiv($("#platformsTable"));
                        }
                    });
                }
            });

        });

        $("body").on("click", "button[data-action=btnDeletePlatform]", function (e) {

            var element, data, elementHtml;
            element = $(this);
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            swal.fire({
                title: "Emin misiniz ?",
                text: element.data("name") + " - " + element.data("store") + " mağazası silinecektir",
                icon: "info",
                showCancelButton: true,
                cancelButtonText: "Hayır, vazgeç",
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Evet, sil",
                reverseButtons: false
            }).then((result) => {
                if (result.value) {

                    data = {};


                    $.ajax({
                        url: element.data('href'),
                        type: "POST",
                        data: data,
                        dataType: "json",
                        success: function (result) {

                            if (result.status === true) {
                                toastr.success(result.message);
                                getStores()
                            } else {
                                Swal.fire("Hata !", result.message, "error");
                            }
                            element.html(elementHtml).removeAttr('disabled');
                        },
                        error: function (error) {
                            element.html(elementHtml).removeAttr('disabled');
                            if (error.responseJSON) {
                                var m = "";
                                if (error.responseJSON.message) {
                                    m = ErrorWB(error.responseJSON.message);
                                }
                                if (error.responseJSON.errors) {

                                    $.each(error.responseJSON.errors, function (i, k) {
                                        m += ErrorWB(k);
                                    });
                                }

                            }
                            Swal.fire("Hata !", m, "error");
                            unblockDiv($("#platformsTable"));
                        }
                    });
                }
            });

        });

        $("body").on('click', '#btnNewStore', async function () {
            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);

            const {value: platform} = await Swal.fire({
                title: 'Platform Seçimi Yapınız',
                input: 'select',
                inputOptions: {
                    3: 'Yemek Sepeti',
                    4: 'Getir Yemek',
                    5: 'Trendyol Yemek'
                },
                inputPlaceholder: 'Platformlar',
                showCancelButton: true,
                cancelButtonText: 'Vazgeç',
                confirmButtonText: 'Devam Et <i class="fa fa-forward"></i>',
                inputValidator: (value) => {
                    return new Promise((resolve) => {
                        if (value) {
                            resolve()
                        } else {
                            resolve('Platform seçimi yapmanız gerekmektedir.')
                        }
                    })
                }
            })

            if (platform) {

                const {value: platform_name} = await Swal.fire({
                    title: 'Mağaza Adı',
                    input: 'text',
                    inputPlaceholder: 'Platform adını giriniz',
                    showCancelButton: true,
                    cancelButtonText: 'Vazgeç',
                    confirmButtonText: 'Oluştur',
                    inputValidator: (value) => {
                        return new Promise((resolve) => {
                            if (value) {
                                resolve()
                            } else {
                                resolve('Platform için mağaza adını giriniz.')
                            }
                        })
                    }
                })

                if (platform_name) {
                    data = {platform: platform, store_name: platform_name};

                    $.ajax({
                        url: $("meta[name=_createStore]").attr("content"),
                        type: "POST",
                        data: data,
                        dataType: "json",
                        success: function (result) {

                            if (result.status) {
                                getStores()
                                toastr.success(result.message);
                            } else {
                                toastr.error(result.message);
                            }

                        },
                        complete: function () {
                            element.html(elementHtml).removeAttr('disabled');
                        },
                        error: function (error) {
                            element.html(elementHtml).removeAttr('disabled');
                            if (error.responseJSON) {
                                var m = "";
                                if (error.responseJSON.message) {
                                    m = ErrorWB(error.responseJSON.message);
                                }
                                if (error.responseJSON.errors) {

                                    $.each(error.responseJSON.errors, function (i, k) {
                                        m += ErrorWB(k);
                                    });
                                }

                            }
                            Swal.fire("Hata !", m, "error");

                        }
                    });
                } else {
                    element.html(elementHtml).removeAttr('disabled');
                }
            } else {
                element.html(elementHtml).removeAttr('disabled');
            }


        });
        let btnLastPlatform;
        $("body").on("click", "button[data-action=btnPlatformAuth]", function (e) {

            var element, data, elementHtml;
            element = $(this);
            btnLastPlatform = element;
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);


            $.ajax({
                url: element.data('href'),
                type: "POST",
                data: {},
                dataType: "json",
                success: function (result) {

                    if (result.status) {
                        $("#platformModal").html(result.view).modal('show');

                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                    unblockDiv($("#menuTable"));
                }
            });

        });

        $("body").on("click", "button[data-action=btnGetRestaurantInfo]", function (e) {

            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);


            $.ajax({
                url: element.data('href'),
                type: "POST",
                data: {'store': $("input[name=IDMAGAZA]").val()},
                dataType: "json",
                success: function (result) {

                    if (result.status) {

                        if (element.data('platform') === "getir") {
                            $("input[name='config[getir_restaurant_id]']").val(result.data.id ?? "")
                        } else if (element.data('platform') === 'ys') {

                            $("input[name='config[ys_restaurant_code]']").val(result.data[0].platformRestaurantId ?? "")
                        } else {
                            $("input[name='config[trendyol_restaurant_id]']").val(result.data.restaurants[0].id ?? "")
                        }


                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {
                    element.html(elementHtml).removeAttr('disabled');
                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                    unblockDiv($("#menuTable"));
                }
            });

        });


        $("body").on("click", "button[data-action=btnPlatformSettings]", function (e) {

            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);


            $.ajax({
                url: element.data('href'),
                type: "POST",
                data: {},
                dataType: "json",
                success: function (result) {

                    if (result.status) {
                        $("#platformModal").html(result.view).modal('show');
                        initPaymentMethodsTable();
                        clientSelect();
                        $('.timepicker').timepicker({
                            template: 'modal',
                            timeFormat: 'HH:mm',
                            interval: 15,
                            minTime: '0',
                            maxTime: '23:45',
                            startTime: '5',
                            dynamic: false,
                            dropdown: true,
                            scrollbar: true
                        });
                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                    unblockDiv($("#menuTable"));
                }
            });

        });

        $("body").on("click", "button[data-action=btnGetRestaurantWorkingHours]", function (e) {

            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);


            $.ajax({
                url: element.data('href'),
                type: "POST",
                data: {'store': $("input[name=IDMAGAZA]").val()},
                dataType: "json",
                success: function (result) {

                    if (result.status) {

                        $.each(result.data.restaurantWorkingHours, function (i, v) {

                            if (v.closed) {
                                $("input[name='restaurantWorkingHours[" + v.day + "][closed]']").attr('checked', true)
                            } else {
                                $("input[name='restaurantWorkingHours[" + v.day + "][workingHours][startTime]']").val(v.workingHours.startTime);
                                $("input[name='restaurantWorkingHours[" + v.day + "][closed]']").removeAttr('checked')
                                $("input[name='restaurantWorkingHours[" + v.day + "][workingHours][endTime]']").val(v.workingHours.endTime);
                            }

                        })

                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                    unblockDiv($("#menuTable"));
                }
            });

        });

        $("body").on("click", "button[data-action=btnGetRestaurantPaymentMethods]", function (e) {

            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);


            $.ajax({
                url: element.data('href'),
                type: "POST",
                data: {'store': $("input[name=IDMAGAZA]").val()},
                dataType: "json",
                success: function (result) {

                    if (result.status) {

                        paymentMethods.ajax.reload(null, false);
                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                    unblockDiv($("#menuTable"));
                }
            });

        });
        var paymentMethods;

        function clientSelect() {
            $("select[name=client]").select2({
                placeholder: 'Firma Seçimi',
                allowClear: true,
                dropdownParent: $('#platformModal'),
                ajax: {
                    method: "post",
                    url: $("meta[name=_getClientsForSelect]").attr('content'),
                    cache: true,
                    data: function (query) {
                        return {term: query.term}
                    }
                }
            });

        }

        function initPaymentMethodsTable() {
            //   paymentMethods

            paymentMethods = $("#paymentMethods").dataTable({

                "PaginationType": "bootstrap",

                ordering: false,
                processing: true,
                paginate: true,
                responsive: true,
                info: true,
                scrollY: '40vh',
                scrollX: false,

                "language": {
                    "url": $("meta[name=_trDatatable]").attr("content"),
                },

                ajax: {
                    "url": $("#paymentMethods").data("action"),
                    "type": "POST",
                    "data": function () {
                        return {action: 'complete'}
                    },
                    "error": function (error) {

                        if (error.responseJSON) {
                            var m = "";
                            if (error.responseJSON.message) {
                                m = ErrorWB(error.responseJSON.message);
                            }
                            if (error.responseJSON.errors) {

                                $.each(error.responseJSON.errors, function (i, k) {
                                    m += ErrorWB(k);
                                });
                            }

                        }
                        if (m.length > 0) Swal.fire("Hata", m, "error");

                    }
                },

                rowId: "rowID",

                "preDrawCallback": function () {

                },

                "fnInitComplete": function () {

                },

                aLengthMenu: [[100, -1], [100, "Tümü"]],
                "pageLength": 100,

                "fnCreatedRow": function (nRow, aData, iDataIndex) {
                    $(nRow).attr('id', aData["rowID"]);
                },

                "fnDrawCallback": function () {

                },

                "aoColumnDefs": [
                    {
                        'bSortable': false,
                        'aTargets': [0]
                    },


                ],


            });
            paymentMethods = $("#paymentMethods").DataTable();


        }


        $("body").on('click', 'a[href="#paymentMethodsTab"]', function () {
            setTimeout(function () {
                console.log("tık")
                paymentMethods.columns.adjust().draw();
            }, 250)
        })

        $("body").on('change', 'select[name=IDISLEM_F]', function () {

            $.ajax({
                url: $("meta[name=_setPlatformPaymentMethod]").attr("content"),
                type: "POST",
                data: {qs_payment_method: $(this).val(), platform_payment_method: $(this).parents('tr').attr('id')},
                dataType: "json",
                success: function (result) {

                    if (result.status) {
                        toastr.success(result.message);

                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    //          element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {
                    //       element.html(elementHtml).removeAttr('disabled');
                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                    unblockDiv($("#menuTable"));
                }
            });
        })

        $("body").on('click', 'button[data-action=btnSetPaymentMethodStatus]', function () {

            var element, data, elementHtml;
            element = $(this);
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            data = {
                payment_method: element.parents("tr").attr("id"),
                store: $("input[name=IDMAGAZA]").val(),
                type: element.data('type')
            };

            $.ajax({
                url: $("meta[name=_setPlatformPaymentMethodStatus]").attr("content"),
                type: "POST",
                data: data,
                dataType: "json",
                success: function (result) {

                    if (result.status) {
                        toastr.success(result.message);
                        //     paymentMethods = $("#paymentMethods").DataTable();
                        paymentMethods.ajax.reload(null, false);
                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {
                    element.html(elementHtml).removeAttr('disabled');
                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                    unblockDiv($("#menuTable"));
                }
            });
        })

        $("body").on("submit", "#authForm", function (e) {
            e.preventDefault();
            var element, data, elementHtml;
            element = $("#btnAuthFormSubmit");
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            data = $(this).serialize();

            $.ajax({
                url: $(this).attr("action"),
                type: "POST",
                data: data,
                dataType: "json",
                success: function (result) {

                    if (result.status) {
                        toastr.success(result.message);
                        btnLastPlatform.click();
                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {
                    element.html(elementHtml).removeAttr('disabled');
                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                    unblockDiv($("#menuTable"));
                }
            });

        });

        $("body").on("submit", "#settingForm", function (e) {
            e.preventDefault();
            var element, data, elementHtml;
            element = $("#btnSettingFormSubmit");
            elementHtml = element.html();
            element.html('<i class="fa fa-spinner fa-pulse"></i>').attr('disabled', true);
            data = $(this).serialize();

            $.ajax({
                url: $(this).attr("action"),
                type: "POST",
                data: data,
                dataType: "json",
                success: function (result) {

                    if (result.status) {
                        toastr.success(result.message);
                        getStores()
                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {
                    element.html(elementHtml).removeAttr('disabled');
                },
                error: function (error) {
                    element.html(elementHtml).removeAttr('disabled');
                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");
                    unblockDiv($("#menuTable"));
                }
            });

        });

        getStores()

        function getStores() {

            $.ajax({
                url: $("meta[name=_getStores]").attr("content"),
                type: "POST",
                data: {},
                dataType: "json",
                success: function (result) {

                    if (result.status) {
                        $("#divPlatforms").html(result.view);
                    } else {
                        toastr.error(result.message);
                    }

                },
                complete: function () {

                },
                error: function (error) {

                    if (error.responseJSON) {
                        var m = "";
                        if (error.responseJSON.message) {
                            m = ErrorWB(error.responseJSON.message);
                        }
                        if (error.responseJSON.errors) {

                            $.each(error.responseJSON.errors, function (i, k) {
                                m += ErrorWB(k);
                            });
                        }

                    }
                    Swal.fire("Hata !", m, "error");

                }
            });
        }


    };


    return {
        // public functions
        init: function () {
            _platform();
        },
    };

}();

jQuery(document).ready(function () {
    platforms.init();
});

