<!DOCTYPE html>
<html lang="tr" class="h-100">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="admin, dashboard" />
    <meta name="author" content="4M1a Yazılım" />
    <meta name="robots" content="index, follow" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="Yeemek | Getir - Trendyol - Yemek Sepeti Entegrasyonu" />
    <meta property="og:title" content="Yeemek | Getir - Trendyol - Yemek Sepeti Entegrasyonu" />
    <meta property="og:description" content="Yeemek | Getir - Trendyol - Yemek Sepeti Entegrasyonu" />
    <meta name="format-detection" content="telephone=no">
    <meta name="_token" content="{{csrf_token()}}">
    <title>{{config('app.name')}}</title>
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="./images/favicon.png">
    <!-- SweetAlert -->
    <link href="{{asset('assets/vendor/sweetalert2/dist/sweetalert2.min.css')}}" rel="stylesheet">
    <!-- Toastr -->
    <link rel="stylesheet" href="{{asset('assets/vendor/toastr/css/toastr.min.css')}}">
    <link href="{{asset('assets/css/style.css')}}" rel="stylesheet">


</head>

<body class="h-100">
<div class="authincation h-100">
    <div class="container h-100">
        <div class="row justify-content-center h-100 align-items-center">

            <div class="col-md-12">
                <div class="authincation-content">
                    <div class="row no-gutters">
                        <div class="col-xl-12">
                            <div class="auth-form">
                                <div class="text-center mb-3">
                                   <img src="{{asset('assets/images/logo-full.png')}}" alt="" width="30%">
                                </div>
                                <h4 class="text-center mb-4">Yemeek Kurulum</h4>
                                <form class="form" id="installForm" action="{{route("app.login.action.install")}}">
                                    <div class="card card-custom">
                                        <div class="card-body">
                                            <div class="row form-group">
                                                <div class="col-lg-2 col-form-label font-weight-bold">Firma ID</div>
                                                <div class="col-lg-10">
                                                    <input type="text" class="form-control form-control-solid" placeholder="Firma ID Giriniz" name="company">
                                                    <input type="hidden" class="form-control form-control-solid" name="company_name">
                                                </div>
                                            </div>
                                            <div class="row form-group">
                                                <div class="col-lg-2 col-form-label font-weight-bold">Bilgisayar ID</div>
                                                <div class="col-lg-10">
                                                    <input type="text" class="form-control form-control-solid"  readonly placeholder="Bilgisayar ID" value="{{$machine}}">
                                                </div>
                                            </div>

                                            <div class="row form-group">
                                                <div class="col-lg-2 col-form-label font-weight-bold">Lisans Anahtarı</div>
                                                <div class="col-lg-10">
                                                    <input type="text" class="form-control form-control-solid" placeholder="Lisans Anahtarını Giriniz" name="licence">
                                                </div>
                                            </div>
                                            <div class="row form-group">

                                                <div class="col-lg-10 offset-2">
                                                    <button type="button" class="btn btn-primary btn-block" id="btnCheckLicence" data-action="{{route('app.login.action.check-licence')}}">
                                                        <i class="fa fa-key"></i>Lisansı Kontrol Et
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="clearfix"></div>
                                            <div id="divDatabase" hidden>
                                                <div class="row form-group gutter-t">
                                                    <div class="col-lg-2 col-form-label font-weight-bold">Sunucu</div>
                                                    <div class="col-lg-10">
                                                        <input type="text" class="form-control form-control-solid" placeholder="Sunucu" name="host">
                                                    </div>
                                                </div>
                                                <div class="row form-group">
                                                    <div class="col-lg-2 col-form-label font-weight-bold">Veritabanı</div>
                                                    <div class="col-lg-10">
                                                        <input type="text" class="form-control form-control-solid" placeholder="Veritabanı Yolu" name="database">
                                                    </div>
                                                </div>
                                                <div class="row form-group ">
                                                    <div class="col-lg-2 col-form-label font-weight-bold">Kullanıcı - Şifre</div>
                                                    <div class="col-lg-5">
                                                        <input type="text" class="form-control form-control-solid" placeholder="Veritabanı Kullanıcı Adı" autocomplete="off" name="username">
                                                    </div>
                                                    <div class="col-lg-5">
                                                        <input type="text" class="form-control form-control-solid" placeholder="Veritabanı Şifre" autocomplete="off" name="password">
                                                    </div>

                                                </div>
                                                <div class="row form-group">
                                                    <div class="col-lg-10 offset-2">
                                                        <button type="button" id="btnCheckDatabase" class="btn btn-info btn-block" data-action="{{route('app.login.action.check-database')}}">
                                                            <i class="fa fa-database"></i>Veritabanını Kontrol Et
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="row form-group">
                                                    <div class="col-lg-10 offset-2">
                                                        <button type="submit" id="btnInstallComplete" hidden class="btn btn-success btn-block" >
                                                            <i class="fa fa-server"></i>Kurulum Yap
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <button hidden id="kt_login_signin_submit" class="btn btn-primary font-weight-bold px-9 py-4 my-3 mx-4">Giriş Yap</button>
                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>


<!--**********************************
    Scripts
***********************************-->
<!-- Required vendors -->
<script src="{{asset('assets/vendor/global/global.min.js')}}"></script>
<script src="{{asset('assets/js/custom.min.js')}}"></script>
<script src="{{asset('assets/js/deznav-init.js')}}"></script>
<!-- SweetAlert -->
<script src="{{asset('assets/vendor/sweetalert2/dist/sweetalert2.min.js')}}"></script>
<!-- Toastr -->
<script src="{{asset('assets/vendor/toastr/js/toastr.min.js')}}"></script>
<script src="{{asset('system/install/install.js')}}"></script>

</body>

</html>
