<!DOCTYPE html>
<html lang="{{app()->getLocale()}}">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="admin, dashboard" />
    <meta name="author" content="4M1a Yazılım" />
    <meta name="robots" content="index, follow" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="Yeemek | Getir - Trendyol - Yemek Sepeti Entegrasyonu" />
    <meta property="og:title" content="Yeemek | Getir - Trendyol - Yemek Sepeti Entegrasyonu" />
    <meta property="og:description" content="Yeemek | Getir - Trendyol - Yemek Sepeti Entegrasyonu" />
    <meta property="og:image" content="social-image.png"/>
    <meta name="format-detection" content="telephone=no">
    <meta name="_csrf" content="{{csrf_token()}}">
    <meta name="_setRestaurantStatus" content="{{route('app.integration.action.set.restaurant-status')}}">
    <meta name="_setRestaurantCourierStatus" content="{{route('app.integration.action.set.restaurant-courier-status')}}">
    <meta name="_alertJS" content="{{asset('system/define/alerts.js')}}">
    <meta name="_trDatatable" content="{{asset('assets/vendor/datatables/js/tr.json')}}">
    <meta name="_successOgg" content="{{asset('assets/audio/success.ogg')}}">
    <meta name="_errorOgg" content="{{asset('assets/audio/error.ogg')}}">
    @yield('meta')
    <title>@yield('title') | {{config('app.company_name')}} | {{config('app.name')}} </title>
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="{{asset('assets/images/favicon.png')}}">
    <link href="{{asset('assets/vendor/bootstrap-select/dist/css/bootstrap-select.min.css')}}" rel="stylesheet">
    <!-- SweetAlert -->
    <link href="{{asset('assets/vendor/sweetalert2/dist/sweetalert2.min.css')}}" rel="stylesheet">
    <!-- Toastr -->
    <link rel="stylesheet" href="{{asset('assets/vendor/toastr/css/toastr.min.css')}}">
    <!-- Select2 -->
    <link rel="stylesheet" href="{{asset('assets/vendor/select2/css/select2.min.css')}}">

    <link href="{{asset('assets/css/style.css')}}" rel="stylesheet">
    <link href="{{asset('assets/css/print.min.css')}}" rel="stylesheet">

    @yield('css')
</head>
<body>

<!--*******************
    Preloader start
********************-->
<div id="preloader">
    <div class="sk-three-bounce">
        <div class="sk-child sk-bounce1"></div>
        <div class="sk-child sk-bounce2"></div>
        <div class="sk-child sk-bounce3"></div>
    </div>
</div>
<!--*******************
    Preloader end
********************-->

<!--**********************************
    Main wrapper start
***********************************-->
<div id="main-wrapper" class="@yield('sidebar-class')">

    <!--**********************************
        Nav header start
    ***********************************-->
    @include('layouts.partial.nav_header')
    <!--**********************************
            Nav header end
        ***********************************-->

    <!--**********************************
        Chat box start
    ***********************************-->
    @include('layouts.partial.chatbox')
    <!--**********************************
            Chat box End
        ***********************************-->

    <!--**********************************
        Header start
    ***********************************-->
    @include('layouts.partial.header')
    <!--**********************************
            Header end ti-comment-alt
        ***********************************-->

    <!--**********************************
        Sidebar start
    ***********************************-->
    @include('layouts.partial.sidebar')
    <!--**********************************
            Sidebar end
        ***********************************-->

    <!--**********************************
        Content body start
    ***********************************-->
    <div class="content-body">
        <!-- row -->
        @yield('body')
    </div>
    <!--**********************************
        Content body end
    ***********************************-->

    <!--**********************************
        Footer start
    ***********************************-->
    @include('layouts.partial.footer')
    <!--**********************************
            Footer end
        ***********************************-->

</div>
<!--**********************************
    Main wrapper end
***********************************-->

<!--**********************************
    Scripts
***********************************-->
<!-- Required vendors -->
<script src="{{asset('assets/vendor/global/global.min.js')}}"></script>
<script src="{{asset('assets/js/custom.min.js')}}"></script>
<script src="{{asset('assets/js/deznav-init.js')}}"></script>

<!-- Toastr -->
<script src="{{asset('assets/vendor/toastr/js/toastr.min.js')}}"></script>
<!-- SweetAlert -->
<script src="{{asset('assets/vendor/sweetalert2/dist/sweetalert2.min.js')}}"></script>
<!-- Select2 -->
<script src="{{asset('assets/vendor/select2/js/select2.full.min.js')}}"></script>
<!-- Print.js -->
<script src="{{asset('assets/js/print.min.js')}}"></script>

<script src="{{asset('system/define/general.js')}}"></script>



@yield('js')

</body>

</html>
