@extends('layouts.master')
@section('title',$store->ADI.' Menü Entegrasyon Ayarları')
@section('meta')
    <meta name="_setPlatformStatus" content="{{route('app.settings.platform.action.status')}}">
    <meta name="_getQSMenuSelect" content="{{route('app.menu.action.get.qs-menu-for-select')}}">
    <meta name="_getQSOptionSelect" content="{{route('app.menu.action.get.qs-option-for-select')}}">
    <meta name="_getProductOptions" content="{{route('app.menu.action.get.options')}}">
    <meta name="_matchProduct" content="{{route('app.menu.action.set.match')}}">
    <meta name="_matchOption" content="{{route('app.menu.action.set.option-match')}}">
    <meta name="_removeMatchProduct" content="{{route('app.menu.action.delete.match')}}">
    <meta name="_removeMatchOption" content="{{route('app.menu.action.delete.option-match')}}">
    <meta name="_matchPortion" content="{{route('app.menu.action.set.match-portion')}}">
    <meta name="_matchOptionPortion" content="{{route('app.menu.action.set.option-portion-match')}}">
    <meta name="_matchOptionQuantity" content="{{route('app.menu.action.set.option-quantity')}}">
    <meta name="_getAdditionalPortionView" content="{{route('app.menu.action.get.additional-portion')}}">
    <meta name="_setAdditionalPortion" content="{{route('app.menu.action.set.additional-portion')}}">
    <meta name="_setAdditionalQuantity" content="{{route('app.menu.action.set.additional-quantity')}}">
    <meta name="_setRelationQuantity" content="{{route('app.menu.action.set.relation-quantity')}}">
@endsection

@section('css')
    <link rel="stylesheet" href="{{asset('assets/vendor/datatables/css/jquery.dataTables.min.css')}}">
<style>
    input::-webkit-outer-spin-button,
    input::-webkit-inner-spin-button {
        /* display: none; <- Crashes Chrome on hover */
        -webkit-appearance: none;
        margin: 0; /* <-- Apparently some margin are still there even though it's hidden */
    }

    input[type=number] {
        -moz-appearance:textfield; /* Firefox */
    }
    .form-control{
        padding: 0.25rem !important;

    }
</style>
@endsection
@section('sidebar-class','is-active menu-toggle')
@section('body')
    <input type="hidden" name="store" value="{{(int)$store->IDMAGAZALAR}}">
    <input type="hidden" name="platform" value="{{$store->IDPF}}">
    <input type="hidden" name="hide_portion" value="{{$store->IDPF != 3 ? 1 : 0}}">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Menüler</h4>
                        <div class="form-check custom-checkbox checkbox-warning check-xl">
                            <input type="checkbox" class="form-check-input" checked="" id="show_passive" value="1">
                            <label class="form-check-label" for="show_passive"> Pasifleri Gösterme</label>
                        </div>
                        <button class="btn btn-info" id="btnGetProducts"
                                data-action="{{route('app.integration.action.get.menus')}}">Ürünleri Getir
                        </button>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="menuTable" class="display table" style="table-layout: fixed"
                                   data-action="{{route('app.menu.action.get.menu')}}">
                                <thead>
                                <tr>
                                    <th>Kategori</th>
                                    <th>Ürün Adı</th>
                                    <th>MarkoPOS QS Ürün</th>
                                    <th width="1%">EK</th>
                                    <th width="5%">Miktar</th>
                                    <th width="10%">Porsiyon Ayarı</th>
                                    <th width="10%">Durum</th>
                                    <th width="10%">Opsiyonlar</th>
                                </tr>
                                </thead>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="menuModal"></div>
@endsection


@section('js')
    <script src="{{asset('assets/vendor/datatables/js/jquery.dataTables.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('system/menu/menu.js')}}"></script>
@endsection
