<div class="modal-dialog modal-xl">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title">[{{$products[0]->URUNADI ?? ""}}] Ürün - Porsiyon Eşleme</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal">
            </button>
        </div>
        <div class="modal-body">
            <div class="alert alert-info left-icon-big alert-dismissible fade show">
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="btn-close"><span><i
                            class="mdi mdi-btn-close"></i></span>
                </button>
                <div class="media">
                    <div class="alert-left-icon-big">
                        <span><i class="fa fa-info-circle"></i></span>
                    </div>
                    <div class="media-body">
                        <p class="mb-0">Birden fazla ürün içeren "menü" tarzında ürünlerinizde; spesifik olarak bir veya
                            birden fazla ürüne porsiyon atamak için bu ekranı kullanabilirsiniz.

                            <br> Örn: Menu 1; <br>
                            1.5 PRS Döner <br>
                            1 Ayran
                        </p>
                    </div>
                </div>
            </div>

            <table class="table table-responsive-md" id="optionsTable">
                <thead>
                <tr>

                    <th>Ürün</th>
                    <th width="20%">Miktar</th>
                    <th><strong>Porsiyon</strong></th>


                </tr>
                </thead>
                <tbody>
                @forelse($products as $key => $product)
                    <tr id="{{(int)$product->IDURUNESLEME}}">
                        <td>
                            {{$product->STOK_URUNADI}}
                        </td>
                        <td>
                            <div class="input-group"><input type="number" step="0.01"
                                                            class="form-control form-control-sm text-center font-w900"
                                                            value="{{round(($product->MIKTAR ?? 1),3)}}">
                                <button data-action="btnSaveAdditionalQuantityRelation"  data-product="{{(int) $product->IDURUNLER}}"
                                        class="btn btn-sm btn-primary input-group-text"><i
                                        class="fa fa-check-circle"></i></button>
                            </div>
                        </td>
                        <td>
                            <select class="form-control form-control-sm"
                                    id="productAdditionalPortion_{{(int)$product->IDURUNESLEME}}"
                                    data-product="{{(int) $product->IDURUNLER}}">
                                <option
                                    {{$product->PORSIYON == 0 ? 'selected' : ''}} value="0">Normal
                                </option>
                                <option
                                    {{$product->PORSIYON == 2 ? 'selected' : ''}} value="2">1,5 Porsiyon
                                </option>
                                <option
                                    {{$product->PORSIYON == 1 ? 'selected' : ''}} value="1">0,5 Porsiyon
                                </option>
                            </select>
                        </td>

                    </tr>
                @empty
                    <tr>
                        <td colspan="3" class="text-center">LÜTFEN ÖNCEKİ EKRANDA ÜRÜN EŞLEŞMESİ YAPINIZ</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-danger light" data-bs-dismiss="modal">Kapat</button>
        </div>
    </div>
</div>


