<div class="modal-dialog modal-xxl">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title"> Opsiyon Eşleştirmeleri</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal">
            </button>
        </div>
        <div class="modal-body">

            <table class="table table-responsive-md" id="optionsTable">
                <thead>
                <tr>

                    <th><strong>Opsiyon Kategorisi</strong></th>
                    <th><strong>Opsiyon Adı</strong></th>
                    <th><strong>MarkoPOS QS Çeşniler</strong></th>
                    <th><strong>Miktar</strong></th>
                    <th><strong>Porsiyon</strong></th>
                    <th><strong>Durum</strong></th>

                </tr>
                </thead>
                <tbody>
                @foreach($options as $key => $option)
                    <tr id="{{(int)$option->IDURUNOPSIYONLARI}}">

                        <td>{{$option->KATEGORI}}</td>
                        <td>{{$option->OPSIYONADI}}</td>
                        <td>
                            <select data-action="qs-option-select" data-placeholder="Eşleştirilecek çeşni seçiniz"
                                    style="width: 100%" class="form-control form-control-sm" style="width: 100%">
                                @if($option->option_id)
                                    <option selected
                                            value="{{(int)$option->option_id}}">{{$option->option_name}}</option>
                                @endif
                            </select>
                        </td>
                        <td>
                            <div class="input-group"><input type="number" step="0.01"
                                                            class="form-control form-control-sm text-center font-w900"
                                                            value="{{round($option->MIKTAR,3) ?? 1}}">
                                <button data-action="btnSaveAdditionalOptionQuantityRelation"  data-product="{{(int)$option->IDURUNOPSIYONLARI}}"
                                        class="btn btn-sm btn-primary input-group-text"><i
                                        class="fa fa-check-circle"></i></button>
                            </div>
                        </td>
                        <td>
                            <select class="form-control form-control-sm" id="optionPortion_{{(int)$option->IDURUNOPSIYONLARI}}">
                                <option
                                {{$option->PORSIYON == 0 ? 'selected' : ''}} value="0">Normal</option>
                                <option
                                {{$option->PORSIYON == 2 ? 'selected' : ''}} value="2">1,5 Porsiyon</option>
                                <option
                                {{$option->PORSIYON == 1 ? 'selected' : ''}} value="1">0,5 Porsiyon</option>
                            </select>
                        </td>
                        <td>
                            @if($option->option_id)
                                <span class="badge badge-pill badge-success">EŞLEŞTİRİLDİ</span>
                            @else
                                <span class="badge badge-pill badge-danger">EŞLEŞTİRİLMEDİ</span>
                            @endif
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-danger light" data-bs-dismiss="modal">Kapat</button>
        </div>
    </div>
</div>


