@extends('layouts.master')
@section('title',$store->ADI.' Menü Durum Ayarları')
@section('meta')
    <meta name="_setProductStatus" content="{{route('app.integration.action.set.product-status')}}">
    <meta name="_setProductOptionStatus" content="{{route('app.integration.action.set.product-option-status')}}">
    <meta name="_getProductOptions" content="{{route('app.menu.settings.action.get.options')}}">
@endsection

@section('css')
    <link rel="stylesheet" href="{{asset('assets/vendor/datatables/css/jquery.dataTables.min.css')}}">
@endsection
@section('sidebar-class','is-active menu-toggle')
@section('body')
    <input type="hidden" name="store" value="{{(int)$store->IDMAGAZALAR}}">
    <input type="hidden" name="platform" value="{{$store->IDPF}}">
    <input type="hidden" name="hide_portion" value="{{$store->IDPF != 3 ? 1 : 0}}">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Menüler</h4>
                        <button class="btn btn-info" id="btnGetProducts"
                                data-action="{{route('app.integration.action.get.menus')}}">Ürünleri Getir
                        </button>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="menuTable" class="display table" style="table-layout: fixed"
                                   data-action="{{route('app.menu.settings.action.get.menu')}}">
                                <thead>
                                <tr>
                                    <th>Kategori</th>
                                    <th>Ürün Adı</th>
                                    <th width="10%">Durum</th>
                                    <th width="10%">Opsiyonlar</th>
                                    <th width="10%">İŞLEMLER</th>
                                </tr>
                                </thead>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="menuModal"></div>
@endsection


@section('js')
    <script src="{{asset('assets/vendor/datatables/js/jquery.dataTables.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('system/menu/settings-menu.js')}}"></script>
@endsection
