<div class="chatbox-close" style="right: 500px" id="orderbox-close"></div>
<style>
    @media print {
        #orderDetailFooter {
            display: none;
        }
    }
</style>
<div class="card chat dz-chat-history-box d-block p-0" id="orderboxPrint">
    <div class="card-header">
        <h4>SİPARİŞ #{{(int)$order->IDPFSIPARISLER}}</h4>
    </div>
    <div class="card-body dz-scroll" id="DZ_W_Order_Body3">
        @if($order->IPTAL == 1)
            <h3 class="text-white bg-danger p-2"><i class="fa fa-exclamation"></i> İPTAL EDİLDİ</h3>
        @endif
        @if($order->ZAMANLANMIS == 1)
            <h4 class="text-white bg-info p-2"><i class="fa fa-clock"></i> İleri Tarihli Sipariş <br> Beklenen Teslimat
                zamanı {{date('d.m.Y H:i', strtotime($order->TARIH." ".$order->SAAT))}}</h4>
        @endif
        <div class="row">
            <div class="col-12 text-center">
                <img width="200" src="{{asset('assets/images/platforms/'.$order->platform_logo)}}" alt="">
            </div>
        </div>
        <table class="table table-bordered" id="orderHeaderTable">
            <tbody>
            <tr>
                <td width="30%"><strong>Mağaza</strong></td>
                <td>{{$order->store_name}}</td>
            </tr>
            <tr>
                <td><strong>Sipariş Zamanı</strong></td>
                <td>{{date('d.m.Y H:i', strtotime($order->TARIH." ".$order->SAAT))}}</td>
            </tr>
            <tr>
                <td><strong>Müşteri</strong></td>
                <td>{{$order->MUSTERI}}</td>
            </tr>
            <tr>
                <td><strong>Adres</strong></td>
                <td>{{$order->ADRES}}</td>
            </tr>
            <tr>
                <td><strong>İletişim</strong></td>
                <td>{{$order->TELEFON}}</td>
            </tr>
            <tr>
                <td><strong>Teslimat</strong></td>
                <td>{{$order->TESLIMTURU == 1 ? 'Restoran Kuryesi' : ($order->TESLIMTURU == 2 ? 'Gel-Al Siparişi' : 'Platform Kuryesi')}}</td>
            </tr>
            <tr>
                <td><strong>Ödeme</strong></td>
                <td>{{$order->payment_method}}</td>
            </tr>
            </tbody>
        </table>

        <br>
        <table class="table table-bordered" id="orderDetailTable">
            <thead>
            <tr>
                <th width="50%">Ürün / Opsiyon</th>
                <th class="text-center" width="20%">Fiyat</th>
                <th class="text-center" width="10%">Miktar</th>
                <th class="text-center" width="20%">Tutar</th>
            </tr>
            </thead>
            <tbody>
            @if($order->IDPF == 3)
                @php
                    $items = json_decode($order->SIPARISJSON);
                    $items = $items->products;
                @endphp

                @foreach($items as $item)
                    @php
                        $item = (array) $item;
                    @endphp
                    <tr>
                        <td>
                            <strong>   {{ $item['name']}}</strong>
                            <ul class="small fst-italic" style="padding-left: 5px">
                                @foreach ( $item["selectedToppings"] as $option)
                                    <li>{{$option->name}}</li>
                                @endforeach
                            </ul>
                        </td>
                        <td align="center">
                            {{format_money($item['unitPrice'] ,2,'₺')}}
                        </td>
                        <td align="center">{{ $item['quantity']}}</td>
                        <td align="right">{{format_money( $item['paidPrice'] ,2,'₺')}}</td>
                    </tr>
                @endforeach
            @elseif($order->IDPF == 4)
                @php
                    $items = json_decode($order->SIPARISJSON);
                    $items = $items->products;
                @endphp

                @foreach($items as $item)
                    <tr>
                        <td>
                            {{$item->name->tr}}
                            <ul class="small fst-italic" style="padding-left: 5px">
                                @foreach ($item->displayInfo->options->tr as $option)
                                    <li>&nbsp;{{$option}}</li>
                                @endforeach
                            </ul>
                        </td>
                        <td align="center">
                            {{format_money($item->priceWithOption,2,'₺')}}
                        </td>
                        <td align="center">{{$item->count}}</td>
                        <td align="right">{{format_money($item->totalPriceWithOption,2,'₺')}}</td>
                    </tr>
                @endforeach
            @elseif($order->IDPF == 5)

                @php
                    $items = json_decode($order->SIPARISJSON);
                    $items = $items->lines;
                @endphp

                @foreach($items as $item)
                    <tr>
                        <td>
                            {{$item->name}}
                            <ul class="small fst-italic" style="padding-left: 5px">
                                @foreach ($item->modifierProducts as $modifierProduct)
                                    <li>&nbsp; {{$modifierProduct->name}}</li>
                                @endforeach

                                @foreach ($item->extraIngredients as $extraIngredient)
                                    <li>&nbsp; {{$extraIngredient->name}}</li>
                                @endforeach

                                @if (count($item->removedIngredients))
                                    <li>
                                        &nbsp;{{ "Çıkar: " . implode(",", array_column($item->removedIngredients, 'name'))}}</li>
                                @endif
                            </ul>
                        </td>
                        <td align="center">
                            {{format_money($item->unitSellingPrice,2,'₺')}}
                        </td>
                        <td align="center">{{count($item->items)}}</td>
                        <td align="right">{{format_money($item->unitSellingPrice * count($item->items) ,2, '₺')}}</td>
                    </tr>
                @endforeach
            @endif
            <tr>
                <td colspan="2" align="right" class="font-w500">Toplam</td>
                <td colspan="2" align="center" class="font-w500">{{format_money($order->TOPLAM,2,' TL')}}</td>
            </tr>
            @if($order->TOPLAM != $order->INDIRIMLI_TOPLAM)
                <tr>
                    <td colspan="2" align="right" class="font-w500">İndirimli Toplam</td>
                    <td colspan="2" align="center"
                        class="font-w500">{{format_money($order->INDIRIMLI_TOPLAM,2,' TL')}}</td>
                </tr>
            @endif
            </tbody>

        </table>

        <table class="table" id="orderDetailTable">
            @if($order->MUSTERINOTU)
                <tr>
                    <td>Not: {{$order->MUSTERINOTU}}</td>
                </tr>
            @endif
            @if($order->CEVREDOSTU == "1")
                <tr>
                    <td>Lütfen plastik çatal, bıçak, peçete göndermeyin.</td>
                </tr>
            @endif
            @if($order->KAPICALMA == "1")
                <tr>
                    <td>Lütfen Zili Çalmayın.</td>
                </tr>
            @endif
        </table>
    </div>
    <div class="card-footer" id="orderDetailFooter">
        <button class="btn btn-info btn-block btn-xs" type="button" data-action="btnPrintOrder"><i
                class="fa fa-print"></i> Yazdır
        </button>
    </div>
</div>
