<html>
<head>
    <style>
        body {
            font-family: Calibri;
            -webkit-touch-callout: none;
            -webkit-user-select: none;
            -khtml-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
        }

        th {
            height: 30px;
            background-color: #f3f6f9;
            border-bottom: 0;
            letter-spacing: 1px;
            font-weight: 600;
            color: #b5b5c3 !important;
            font-size: .9rem;
            text-transform: uppercase;
            border: 1px solid #ebedf3
        }

        td {
            height: 30px;
            border: 1px solid #cbc8c8
        }</style>
</head>
<body>
<img src="{{asset('assets/images/platforms/ys.png')}}">
<table width="100%">
    <thead>
    <tr>
        <th>ÜRÜN - OPSİYON</th>
        <th>FİYAT</th>
        <th>MİKTAR</th>
        <th>TOPLAM</th>
    </tr>
    </thead>
    <tbody>

    @foreach($items as $item)

        @switch($platform)
            @case(3)
                <tr>
                    <td>
                        {{$item['Name']}}
                        @foreach ($item['Options'] as $option)
                            <br>  <i class="small">{{$option}}</i>
                        @endforeach
                    </td>
                    <td align="right">{{format_money($item['Price'],2)}} TL</td>
                    <td align="right">{{$item['Quantity']}}</td>
                    <td align="right">{{format_money($item['ListPrice'],2)}} TL</td>
                </tr>
                @break
            @case(4)
                <tr>
                    <td>
                        {{$item->displayInfo->title->tr ?? $item->displayInfo->title->en}}
                        @foreach ($item->displayInfo->options->tr as $option)
                            <br>   <i class="small"> {{$option}}</i>
                        @endforeach
                    </td>
                    <td align="right">{{format_money($item->price,2)}} TL</td>
                    <td align="right">{{$item->count}}</td>
                    <td align="right">{{format_money($item->totalPriceWithOption,2)}} TL</td>
                </tr>
                @break
            @case(5)
                <tr>
                    <td>
                        {{$item->name}}

                        @foreach ($item->modifierProducts as $modifierProduct)
                            <br><i class="small"> {{$modifierProduct->name}}</i>
                        @endforeach

                        @foreach ($item->extraIngredients as $extraIngredient)
                            <br><i class="small">  {{$extraIngredient->name}}</i>
                        @endforeach

                        @if (count($item->removedIngredients))

                            <br><i class="small"> {{ "Çıkar: " . implode(",", array_column($item->removedIngredients, 'name'))}}</i>
                        @endif
                    </td>
                    <td align="right">{{format_money($item->unitSellingPrice,2)}} TL</td>
                    <td align="right">{{count($item->items)}}</td>
                    <td align="right">{{format_money($item->unitSellingPrice * count($item->items) ,2)}} TL</td>
                </tr>
                @break
        @endswitch
    @endforeach

    </tbody>
</table>
</body>
</html>
