<!doctype html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
    <link href="{{public_path('assets/css/qs-style.css')}}" rel="stylesheet">
</head>
<body>
<div class="content-body">
    <div class="chatbox">
        <div class="card chat dz-chat-history-box d-block p-0" id="orderboxPrint">

            <div class="card-body text-center dz-scroll" id="DZ_W_Order_Body3">

                @if($orderDetail->ZAMANLANMIS == 1)
                    <h4 class="text-white bg-info p-2"><i class="fa fa-clock"></i> İleri Tarihli Sipariş <br> Beklenen Teslimat zamanı {{date('d.m.Y H:i', strtotime($orderDetail->TARIH." ".$orderDetail->SAAT))}}</h4>
                @endif

                @if($orderDetail->IDPF ==3)
                    <img width="200" src="{{public_path('assets/images/platforms/ys.png')}}" alt="">
                @elseif($orderDetail->IDPF == 4)
                    <img width="200" src="{{public_path('assets/images/platforms/gy.png')}}" alt="">
                @elseif($orderDetail->IDPF == 5)
                    <img width="200" src="{{public_path('assets/images/platforms/trendyol-yemek.png')}}" alt="">
                @endif
                <table class="table table-bordered" id="orderHeaderTable">
                    <tbody>
                    <tr>
                        <td width="40%"><strong>Mağaza</strong></td>
                        <td>{{$store->ADI}}</td>
                    </tr>
                    <tr>
                        <td><strong>Sipariş Zamanı</strong></td>
                        <td>{{date('d.m.Y H:i', strtotime($orderDetail->TARIH." ".$orderDetail->SAAT))}}</td>
                    </tr>
                    <tr>
                        <td><strong>Müşteri</strong></td>
                        <td>{{$orderDetail->MUSTERI}}</td>
                    </tr>
                    <tr>
                        <td><strong>Adres</strong></td>
                        <td>{{$orderDetail->ADRES}}</td>
                    </tr>
                    <tr>
                        <td><strong>İletişim</strong></td>
                        <td>{{$orderDetail->TELEFON}}</td>
                    </tr>
                    <tr>
                        <td><strong>Teslimat</strong></td>
                        <td>{{$orderDetail->TESLIMTURU == 1 ? 'Restoran Kuryesi' : ($orderDetail->TESLIMTURU == 2 ? 'Gel-Al Siparişi' : 'Platform Kuryesi')}}</td>
                    </tr>
                    <tr>
                        <td><strong>Ödeme</strong></td>
                        <td>{{$payment_method->ADI ?? ""}}</td>
                    </tr>
                    </tbody>
                </table>

                <br>
                <table class="table table-bordered" id="orderDetailTable">
                    <thead>
                    <tr>
                        <th width="50%">Ürün / Opsiyon</th>
                        <th class="text-center" width="20%">Fiyat</th>
                        <th class="text-center" width="10%">Miktar</th>
                        <th class="text-center" width="20%">Tutar</th>
                    </tr>
                    </thead>
                    <tbody>
                    @if($orderDetail->IDPF == 3)
                        @php
                            $items = json_decode($orderDetail->SIPARISJSON);
                            $items = $items->products;
                        @endphp

                        @foreach($items as $item)
                            @php
                                $item = (array) $item;
                            @endphp
                            <tr>
                                <td>
                                    <strong>{{ $item['name']}}</strong>
                                    <ul class="small fst-italic" style="padding-left: 5px">
                                        @foreach ( $item["selectedToppings"] as $optionIndex => $optionParent)
                                            @if($optionParent->remoteCode != null)
                                                @foreach($optionParent->children as $option)
                                                    <li> {{($optionIndex+1).". Ürün | ". $option->name}}</li>
                                                @endforeach
                                            @else
                                                <li>{{$option->name}}</li>
                                            @endif

                                        @endforeach
                                    </ul>
                                </td>
                                <td align="center">
                                    {{format_money($item['unitPrice'] ,2,'TL')}}
                                </td>
                                <td align="center">{{ $item['quantity']}}</td>
                                <td align="right">{{format_money( $item['paidPrice'] ,2,'TL')}}</td>
                            </tr>
                        @endforeach
                    @elseif($orderDetail->IDPF == 4)
                        @php
                            $items = json_decode($orderDetail->SIPARISJSON);
                            $items = $items->products;
                        @endphp

                        @foreach($items as $item)
                            <tr>
                                <td>
                                    <strong>   {{$item->name->tr}}</strong>
                                    <ul class="small fst-italic" style="padding-left: 5px">
                                        @foreach ($item->displayInfo->options->tr as $option)
                                            <li>{{$option}}</li>
                                        @endforeach
                                    </ul>
                                </td>
                                <td align="center">
                                    {{format_money($item->priceWithOption,2,'TL')}}
                                </td>
                                <td align="center">{{$item->count}}</td>
                                <td align="right">{{format_money($item->totalPriceWithOption,2,'TL')}}</td>
                            </tr>
                        @endforeach
                    @elseif($orderDetail->IDPF == 5)

                        @php
                            $items = json_decode($orderDetail->SIPARISJSON);
                            $items = $items->lines;
                        @endphp

                        @foreach($items as $item)
                            <tr>
                                <td>
                                    <strong>    {{$item->name}}</strong>
                                    <ul class="small fst-italic" style="padding-left: 5px">
                                        @foreach ($item->modifierProducts as $modifierProduct)
                                            <li> {{$modifierProduct->name}}</li>
                                        @endforeach

                                        @foreach ($item->extraIngredients as $extraIngredient)
                                            <li> {{$extraIngredient->name}}</li>
                                        @endforeach

                                        @if (count($item->removedIngredients))
                                            <li>
                                                {{ "Çıkar: " . implode(",", array_column($item->removedIngredients, 'name'))}}</li>
                                        @endif
                                    </ul>
                                </td>
                                <td align="center">
                                    {{format_money($item->unitSellingPrice,2,'TL')}}
                                </td>
                                <td align="center">{{count($item->items)}}</td>
                                <td align="right">{{format_money($item->unitSellingPrice * count($item->items) ,2, 'TL')}}</td>
                            </tr>
                        @endforeach
                    @endif
                    <tr>
                        <td colspan="2" align="right" class="font-w500">Toplam</td>
                        <td colspan="2" align="center"
                            class="font-w500">{{format_money($orderDetail->TOPLAM,2,' TL')}}</td>
                    </tr>
                    @if($orderDetail->TOPLAM != $orderDetail->INDIRIMLI_TOPLAM)
                        <tr>
                            <td colspan="2" align="right" class="font-w500">İndirimli Toplam</td>
                            <td colspan="2" align="center"
                                class="font-w500">{{format_money($orderDetail->INDIRIMLI_TOPLAM,2,' TL')}}</td>
                        </tr>
                    @endif
                    </tbody>

                </table>

                <table class="table" id="orderDetailTable">
                    @if($orderDetail->MUSTERINOTU)
                        <tr>
                            <td>Not: {{$orderDetail->MUSTERINOTU}}</td>
                        </tr>
                    @endif
                    @if($orderDetail->CEVREDOSTU == "1")
                        <tr>
                            <td>Lütfen plastik çatal, bıçak, peçete göndermeyin.</td>
                        </tr>
                    @endif
                    @if($orderDetail->KAPICALMA == "1")
                        <tr>
                            <td>Lütfen Zili Çalmayın.</td>
                        </tr>
                    @endif
                </table>
            </div>

        </div>
    </div>
</div>

</body>
</html>



