@extends('layouts.master')
@section('title',"Tüm Siparişler")
@section('meta')
    <meta name="_getOrder" content="{{route('app.order.action.get.order','id')}}">
    <meta name="_getCouriers" content="{{route('app.order.action.get.couriers')}}">
    <meta name="_confirmOrder" content="{{route('app.order.action.confirm.order','id')}}">
    <meta name="_deliverOrder" content="{{route('app.order.action.deliver.order','id')}}">
    <meta name="_handoverOrder" content="{{route('app.order.action.handover.order','id')}}">
    <meta name="_rejectOrder" content="{{route('app.order.action.reject.order','id')}}">
    <meta name="_rejectOrderStatuses" content="{{route('app.order.action.reject-status.order','id')}}">
@endsection

@section('css')
    <link rel="stylesheet" href="{{asset('assets/vendor/datatables/css/jquery.dataTables.min.css')}}">
    <style>
        .table.dataTable thead th {
            font-size: 14px;
            font-weight: bold;
        }

        td {
            font-size: 12px;
        }

        #orderHeaderTable tbody td, #orderDetailTable thead th, #orderDetailTable tbody td {
            font-size: small;
            padding: 5px;
        }

        .swal2-checkbox label, .swal2-radio label {
            display: block;
        }
    </style>
@endsection
@section('sidebar-class','is-active menu-toggle')
@section('body')

    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-custom gutter-b">
                    <div class="card-body">
                        <form class="form" id="searchForm">
                            <div class="row ">
                                <div class="col-lg-4 mb-lg-0">
                                    <label>İşlem Tarihi</label>
                                    <div class="input-daterange input-group" id="kt_datepicker">
                                        <div class="input-group-text cursor-pointer" id="btnDatePrev">
                                            <i class="fa fa-backward"></i>
                                        </div>
                                        <input type="text" class="form-control datatable-input" name="start_date"
                                               placeholder="Başlangıç Tarihi" autocomplete="off" data-col-index="5"
                                               value="{{date("d.m.Y")}}">
                                        <div class="input-group-text ">

                                            <i class="la la-ellipsis-h"></i>

                                        </div>
                                        <input type="text" class="form-control datatable-input" name="end_date"
                                               placeholder="Bitiş Tarihi" data-col-index="5" autocomplete="off"
                                               value="{{date("d.m.Y")}}">
                                        <div class="input-group-text cursor-pointer" id="btnDateNext">

                                            <i class="fa fa-forward"></i>

                                        </div>
                                    </div>
                                </div>


                                <div class="col-lg-4 float-right">
                                    <label>&nbsp;</label><br>
                                    <button class="btn btn-primary " id="kt_search">
													<span>
														<i class="fa fa-search"></i>
														<span>Ara</span>
													</span>
                                    </button>&nbsp;&nbsp;
                                    <button class="btn btn-secondary btn-secondary--icon" id="kt_reset" type="button">
													<span>
														<i class="fa fa-times"></i>
														<span>Sıfırla</span>
													</span>
                                    </button>
                                </div>
                            </div>
                            <div class="row mt-1">
                                <div class="col-lg-12 col-sm-12 ">
                                    <button type="button" class="btn light btn-danger btn-primary--icon"
                                            id="btnDateToday">
                                        <span>Bugün</span></button>&nbsp;
                                    <button type="button" class="btn light btn-warning btn-primary--icon"
                                            id="btnDateYesterday">
                                        <span>Dün</span></button>&nbsp;
                                    <button type="button" class="btn light btn-info btn-primary--icon"
                                            id="btnDateThisWeek">
                                        <span>Bu Hafta</span></button>&nbsp;
                                    <button type="button" class="btn light btn-dark btn-primary--icon"
                                            id="btnDateThisMonth">
                                        <span>Bu Ay</span></button>&nbsp;
                                    <button type="button" class="btn light btn-success btn-primary--icon"
                                            id="btnDateThisYear">
                                        <span>Bu Yıl</span></button>&nbsp;
                                </div>
                            </div>

                        </form>
                    </div>
                </div>

            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="card">

                    <div class="card-body p-2">
                        <div class="table-responsive">
                            <table id="ordersTable" class="w-100 display table table-hover"
                                   data-action="{{route('app.order.action.get.orders')}}" data-type="all">
                                <thead>
                                <tr>
                                    <th>Platform</th>
                                    <th>Mağaza</th>
                                    <th>S. Tarihi</th>
                                    <th>S. Saati</th>
                                    <th>Müşteri</th>
                                    <th>Toplam</th>
                                    <th>O. Süresi</th>
                                    <th>H. Süresi</th>
                                    <th>T. Süre</th>
                                    <th>Durum</th>
                                    <th>Ödeme</th>
                                    <th>Kurye</th>
                                    <th></th>
                                </tr>
                                </thead>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
        </div>

    </div>
    <div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="ordersModal"></div>
    <div class="chatbox" id="orderbox" style="width: 500px">
    </div>
@endsection


@section('js')
    <script src="{{asset('assets/vendor/datatables/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.printElement.min.js')}}"></script>
    <script src="{{asset('assets/vendor/moment/moment.min.js')}}"></script>
    <script src="{{asset('assets/js/datepicker/js/bootstrap-datepicker.min.js')}}"></script>
    <script src="{{asset('assets/js/datepicker/bootstrap-datepicker.tr.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('system/order/history-orders.js')}}"></script>
@endsection
