@extends('layouts.master')
@section('title',"Siparişler")
@section('meta')
    <meta name="_getOrder" content="{{route('app.order.action.get.order','id')}}">
    <meta name="_getCouriers" content="{{route('app.order.action.get.couriers')}}">
    <meta name="_confirmOrder" content="{{route('app.order.action.confirm.order','id')}}">
    <meta name="_deliverOrder" content="{{route('app.order.action.deliver.order','id')}}">
    <meta name="_handoverOrder" content="{{route('app.order.action.handover.order','id')}}">
    <meta name="_rejectOrder" content="{{route('app.order.action.reject.order','id')}}">
    <meta name="_rejectOrderStatuses" content="{{route('app.order.action.reject-status.order','id')}}">
@endsection

@section('css')
    <link rel="stylesheet" href="{{asset('assets/vendor/datatables/css/jquery.dataTables.min.css')}}">
    <style>
        .table.dataTable thead th {
            font-size: 14px;
            font-weight: bold;
        }

        td {
            font-size: 12px;
        }

        #orderHeaderTable tbody td, #orderDetailTable thead th,#orderDetailTable tbody td {
            font-size: small;
            padding: 5px;
        }
        .swal2-checkbox label, .swal2-radio label{
            display: block;
        }
    </style>
@endsection
@section('sidebar-class','is-active menu-toggle')
@section('body')

    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header p-2 bg-warning">
                        <h4 class="card-title text-white">Aktif Siparişler</h4>
                    </div>
                    <div class="card-body p-2">
                        <div class="table-responsive">
                            <table id="pendingOrdersTable" class="w-100 display table table-hover" data-action="{{route('app.order.action.get.orders')}}">
                                <thead>
                                <tr>
                                    <th>Platform</th>
                                    <th>Mağaza</th>
                                    <th>S. Tarihi</th>
                                    <th>S. Saati</th>
                                    <th>Müşteri</th>
                                    <th>Toplam</th>
                                    <th>O. Süresi</th>
                                    <th>H. Süresi</th>
                                    <th>T. Süre</th>
                                    <th>Durum</th>
                                    <th>Ödeme</th>
                                    <th>Kurye</th>
                                    <th></th>
                                </tr>
                                </thead>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header p-2 bg-success">
                        <h4 class="card-title text-white">Tamamlanan Siparişler</h4>
                    </div>
                    <div class="card-body p-2">
                        <div class="table-responsive">
                            <table id="completeOrdersTable" class="w-100 display table" data-action="{{route('app.order.action.get.orders')}}" data-type="current_date">
                                <thead>
                                <tr>
                                    <th>Platform</th>
                                    <th>Mağaza</th>
                                    <th>S. Tarihi</th>
                                    <th>S. Saati</th>
                                    <th>Müşteri</th>
                                    <th>Toplam</th>
                                    <th>O. Süresi</th>
                                    <th>H. Süresi</th>
                                    <th>T. Süre</th>
                                    <th>Durum</th>
                                    <th>Ödeme</th>
                                    <th>Kurye</th>
                                    <th></th>

                                </tr>
                                </thead>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="ordersModal"></div>
    <div class="chatbox" id="orderbox" style="width: 500px">
    </div>
@endsection


@section('js')
    <script src="{{asset('assets/vendor/datatables/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.printElement.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('system/order/orders.js')}}"></script>
@endsection
