@extends('layouts.master')
@section('title','Platform Ayarları')
@section('meta')
    <meta name="_setPlatformStatus" content="{{route('app.settings.platform.action.status')}}">
    <meta name="_createStore" content="{{route('app.settings.platform.action.create')}}">
    <meta name="_getStores" content="{{route('app.settings.platform.action.get')}}">
    <meta name="_setPlatformPaymentMethod" content="{{route('app.settings.platform.action.payment-method')}}">
    <meta name="_setPlatformPaymentMethodStatus" content="{{route('app.integration.action.set.payment-methods')}}">
    <meta name="_getClientsForSelect" content="{{route('app.settings.platform.get.clients-for-select')}}">
@endsection

@section('css')
    <link rel="stylesheet" href="{{asset('assets/vendor/datatables/css/jquery.dataTables.min.css')}}">
    <link href="{{asset('assets/vendor/timepicker/jquery.timepicker.min.css')}}" rel="stylesheet">
    <style>
        .ui-timepicker-standard{
z-index: 9999!important;
        }</style>
@endsection

@section('body')

    <div class="container-fluid">
        <div class="row">
            <div class="col-12 rtl float-right mb-2">
                <button class="btn btn-success" id="btnNewStore">Yeni Mağaza <i class="fa fa-store"></i></button>
            </div>
        </div>
        <div id="divPlatforms"></div>
    </div>
    <div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="platformModal"></div>
@endsection


@section('js')
    <script src="{{asset('assets/vendor/datatables/js/jquery.dataTables.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('assets/vendor/timepicker/jquery.timepicker.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('system/settings/platform/platform.js')}}"></script>
@endsection
