<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Order\OrderController;
use App\Http\Controllers\Integration\IntegrationController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/



Route::group(['namespace' => 'Order',], function () {
    Route::post('/order/{id}/confirm',[OrderController::class,'confirmOrder']);
    Route::post('/order/{id}/cancel',[OrderController::class,'rejectOrder']);
    Route::post('/order/{id}/delivery',[OrderController::class,'deliverOrder']);
    Route::post('/order/{id}/complete',[OrderController::class,'handoverOrder']);
    Route::any('/store',[IntegrationController::class,'store'])->name('app.api.view.store');
    Route::any('/store/status',[IntegrationController::class,'setRestaurantStatus'])->name('app.api.set.store');
    Route::any('/store/courier',[IntegrationController::class,'setRestaurantCourierStatus'])->name('app.api.set.courier');

});

Route::get('/update', function (\Codedge\Updater\UpdaterManager $updater) {

    // Check if new version is available
    try{

        echo "Kurulu Versiyon :: ". $updater->source()->getVersionInstalled();

        echo "<br>";

        if($updater->source()->isNewVersionAvailable()) {

            // Get the current installed version


            // Get the new version available
            $versionAvailable = $updater->source()->getVersionAvailable();
            echo $versionAvailable;
            echo "<br>";

            // Create a release
            $release = $updater->source()->fetch($versionAvailable);

            // Run the update process
            $updater->source()->update($release);

            echo "Update tamamlandı :: " . $release->getVersion();

        } else {
            echo "No new version available.";
        }
    }catch (Exception $e){
        throw  $e;
    }

});
